#ifndef MEASURING_WHEEL_H
#define MEASURING_WHEEL_H

#include "mbed.h"
#include "QEI.h"
//#include "r1307.h"
#include "OmniPosition.h"
#define PI 3.141592653589793

class MeasuringWheel
{
public :
    MeasuringWheel(PinName channel1_1, PinName channel1_2, PinName channel2_1, PinName channel2_2, PinName channel3_1, PinName channel3_2);
//    bool

    bool wheelDiameter(float diameter1, float diameter2, float diameter3);

    float getOutX();
    float getOutY();
    void transmissionXY();
    float getWheel1(),getWheel2(),getWheel3();
    float getjyroAngle();
    OmniPosition r1370;

private :
    float diameter[3];
    float radian[3];
    float wheel[3],r,X,Y,subX,subY;
    void computeXY();
    
       

    QEI w1;
    QEI w2;
    QEI w3;
//    R1307 r1370;
    float Cdif, yaw;
    Ticker ticker;
    uint16_t X_, Y_,ofsetX, ofsetY;
    char upBitX, upBitY;
    char downBitX,downBitY;
    Serial mainMicon;
    char get;
    DigitalOut led;
    void resetpisithon(); 
//    void rawAngle();
    
    
};

#endif