#ifndef LINEMICONGET_H
#define LINEMICONGET_H

#include "mbed.h"
#include "SerialMultiByte.h"

#define FIRST_HEDDER 0xEE
#define SECOND_HEDDER 0xFF
#define BUFFER_SIZE 12
#define TWO_BYTE_DATA 5
#define ONE_BYTE_DATA 2 


class linemiconget
{

public:

    linemiconget(PinName linegettx, PinName linegetrx);
    void receiveState();
    int getDistance(int number) const;
    int getEncoder(int number) const;
    bool getLine1(int number) const;
    bool getLine2(int number) const;

private:

    uint8_t rxdata[BUFFER_SIZE];
    int data[TWO_BYTE_DATA + ONE_BYTE_DATA];
    bool line1[5], line2[5];
    SerialMultiByte serial;
};

#endif