#include "linemiconget.h"

linemiconget::linemiconget(PinName linegettx, PinName linegetrx):
    serial(linegettx, linegetrx)
{
    serial.baud(115200);
    serial.setHeaders(FIRST_HEDDER, SECOND_HEDDER);
    serial.startReceive(BUFFER_SIZE);
}

void linemiconget::receiveState()
{
    serial.getData(rxdata);
    for(int i = 0; i < TWO_BYTE_DATA; i++) {
        //if((((rxdata[2*i]<<8)|rxdata[2*i+1]) - 32768 > 1200) || (((rxdata[2*i]<<8)|rxdata[2*i+1]) - 32768 < -1)) {
//        } else {
            data[i] = ((rxdata[2*i]<<8)|rxdata[2*i+1]) - 32768;
//        }
    }
        for(int i = 0; i < ONE_BYTE_DATA; i++)data[TWO_BYTE_DATA + i] = rxdata[2*TWO_BYTE_DATA + i];
    for(int i=0; i<5; i++) {
        line1[i] = data[5] % 2;
        data[5] /= 2;
        line2[i] = data[6] % 2;
        data[6] /= 2;

    }
}

int linemiconget::getDistance(int number) const
{
    if((data[number] > 1200) || (data[number] < -1)) {
        return -1;
    } else {
        return data[number];
    }
}

int linemiconget::getEncoder(int number) const
{
    return data[number + 2];
}

bool linemiconget::getLine1(int number) const
{
    return line1[number];
}

bool linemiconget::getLine2(int number) const
{
    return line2[number];
}
