#ifndef BOT_H
#define BOT_H

#include "mbed.h"
#include "controller.h"
#include "ikarashiMDC.h"
#include "QEI.h"
#include "PID.h"
#include "omni_wheel.h"
#include "r1307.h"
//#include "position_controller.h"
#include "OmniPosition.h"

#define PI 3.141592653589793

#define KP 15.0
#define KI 0.092
#define KD 0.00005

#define angleKP 4.0
#define angleKI 50.0
#define angleKD 0.0001
#define RATE 0.01


//#define MOTOR_MODE_STOP      0
//#define MOTOR_MODE_FORWARD   1
//#define MOTOR_MODE_BACKWARD  2
//#define MOTOR_MODE_RIGHT     3
//#define MOTOR_MODE_LEFT      4



class GakuBot
{
public:
    GakuBot();
    void botConfirm();
    void controllerMode1();
    void controllerMode2();
    //void autoMode1();
//    void autoMode2();


    void controllMech();
//    void autoMech();

private:
    DigitalOut led;
    PID  pid,anglePID;
    OmniWheel omni;
    DigitalOut angle1_1,angle1_2;
    DigitalOut angle2_1,angle2_2;
    Controller con;
    QEI wheel1;
    DigitalOut RS485control;
    Serial RS485;
    Serial debugpc;
//    R1307  r1370;
    ikarashiMDC* wheels[4];
    ikarashiMDC* fire[3];
//    ikarashiMDC* Loading[5];
    float stick[4], speed[4], Output_PID,nowAngle, ofsetNowAngle, attachAngle;
    bool airFlag,airFlag2,airStatus,airStatus2;
    int distance, distanceOfset, nowPals;
    bool receiveSuccessed;
    int mode;
    float demoX,demoY;
    Timer t ,confirmT;
    double dt, confirmDt;
    bool pidflag;
    float loadingPwm[5],firePwm[3];
};


#endif//BOT_H