/******************************************************
 * by tamirci::156103010::ST
 * STM32F429I-DISCO Board Can Bus Example 
 * 
 * CAN1_RX -> PD_0,  CAN1_TX -> PD_1
 * LED1    -> PG_13, LED2    -> PG14
 * 
 ******************************************************/
#include "mbed.h"
#include "TS_DISCO_F429ZI.h"
#include "LCD_DISCO_F429ZI.h"

Ticker ticker;              //  timer object for periodic transmission
DigitalOut led1(LED1);      //  GPIO object for LED indication of can tx event
DigitalOut led2(LED2);      //  GPIO object for LED indication of can rx event
CAN can1(PD_0, PD_1);       //  CAN tranmit object::ttl level waves can be captured  
LCD_DISCO_F429ZI lcd;       //  Just to be sure demo application firmware is running

char counter = 0;           //  the value that will be transmitted

void send() {
    printf("send()\n");
    if(can1.write(CANMessage(1337, &counter, 1))) {
        printf("wloop()\n");
        counter++;
        printf("Message sent: %d\n", counter);
    } 
    led1 = !led1;
}
 
int main() {
    
    CANMessage msg;
    BSP_LCD_SetFont(&Font20);
    lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"CAN BUS", CENTER_MODE);
    lcd.DisplayStringAt(0, LINE(6), (uint8_t *)"EXAMPLE", CENTER_MODE);
    lcd.DisplayStringAt(0, LINE(7), (uint8_t *)"156103010", CENTER_MODE);
    lcd.DisplayStringAt(0, LINE(8), (uint8_t *)"ST", CENTER_MODE);
    wait(1);
    printf("main()\n");
    ticker.attach(&send,1);        // send can message over CAN1_TX
    while(1) {
        printf("loop()\n");
        if(can1.read(msg)) {
            printf("Message received: %d\n", msg.data[0]);
            led2 = !led2;
        } 
        wait(0.2);
    }
}