// read analog0 and send to thingspace.io
// toma 2016-11-01

#include "mbed.h"
#include "stdio.h"
#include "SpwfInterface.h"
#include "TCPSocket.h"
#include <string>
#include "x_nucleo_iks01a1.h"

/*************************************
//FRDM-K64: D9->UART1_TX, D7->UART1_RX
Pin connections:
    FRDM      IDW01M1
   ------    ---------
    +3v3 <--> +3v3
    GND  <--> GND
    D9   <--> D8
    D7   <--> D2

SpwfSAInterface spwf(D9, D7, false);
*************************************/
/*************************************
//LPCXpresso11U68: D9->UART1_TX, D7->UART1_RX
Pin connections:
    LPC      IDW01M1
   ------    ---------
    +3v3 <--> +3v3
    GND  <--> GND
    A1   <--> D8
    A2   <--> D2

SpwfSAInterface spwf(A1, A2, false);
*************************************/

//NUCLEO: D8->UART1_TX (PA_9), D2->UART1_RX (PA_10)

using namespace std;

AnalogIn analog_input_A0(A0);
Serial serial_port(USBTX, USBRX);
DigitalOut myLed(LED1);
SpwfSAInterface spwf(D8, D2, false);

/* Instantiate the expansion board */
static X_NUCLEO_IKS01A1 *mems_expansion_board = X_NUCLEO_IKS01A1::Instance(D14, D15);

/* Retrieve the composing elements of the expansion board */
static GyroSensor *gyroscope = mems_expansion_board->GetGyroscope();
static MotionSensor *accelerometer = mems_expansion_board->GetAccelerometer();
static MagneticSensor *magnetometer = mems_expansion_board->magnetometer;
static HumiditySensor *humidity_sensor = mems_expansion_board->ht_sensor;
static PressureSensor *pressure_sensor = mems_expansion_board->pt_sensor;
static TempSensor *temp_sensor1 = mems_expansion_board->ht_sensor;
static TempSensor *temp_sensor2 = mems_expansion_board->pt_sensor;

int errConnect;
int errSend;

/* Helper function for printing floats & doubles */
static char *printDouble(char* str, double v, int decimalDigits=2)
{
  int i = 1;
  int intPart, fractPart;
  int len;
  char *ptr;

  /* prepare decimal digits multiplicator */
  for (;decimalDigits!=0; i*=10, decimalDigits--);

  /* calculate integer & fractinal parts */
  intPart = (int)v;
  fractPart = (int)((v-(double)(int)v)*i);

  /* fill in integer part */
  sprintf(str, "%i.", intPart);

  /* prepare fill in of fractional part */
  len = strlen(str);
  ptr = &str[len];

  /* fill in leading fractional zeros */
  for (i/=10;i>1; i/=10, ptr++) {
    if(fractPart >= i) break;
    *ptr = '0';
  }

  /* fill in (rest of) fractional part */
  sprintf(ptr, "%i", fractPart);

  return str;
}

int main()
{
    uint8_t id;
    float value1, value2;
    char buffer1[32], buffer2[32];
    int32_t axes[3];
    
    float panel_voltage;
    DigitalOut led(LED1);
    serial_port.baud(115200);
    
    printf("\r\n\r\n*** system restart");
    printf("\r\n\r\nanalog0 example using thingspace.io ...\n");
    
    char *ssid = "";
    char *seckey = "";
    const char *mac;
        
    printf("X-NUCLEO-IDW01M1v2 mbed application\r\n");     
        
    int spwfResponse;
    spwfResponse = 0;
    
    while(spwfResponse != 1) {
        printf("connecting to access point ...\r\n");
        spwfResponse = spwf.connect(ssid, seckey, NSAPI_SECURITY_WPA2);//WPA
        printf("\nresponse:  %i\n", spwfResponse);
        if(spwfResponse != 1)
        {
            printf("error making connecting to access point\r\n");
        }
        else
        {
            printf("success connecting to access point\r\n");
            const char *ip = spwf.get_ip_address();
            mac = spwf.get_mac_address();
            printf("\r\nip address = %s\r\n", (ip) ? ip : "error getting ip address");
            printf("mac address = %s\r\n", (mac) ? mac : "error getting the mac address\n");
        }
    }
    
    SocketAddress addrDweetServer(&spwf, "thingspace.io");
    printf("\r\nthingspace.verizon.com resolved to: %s\r\n\r\n", addrDweetServer.get_ip_address());

    TCPSocket socket(&spwf);

    // connect socket
    errConnect = socket.connect("thingspace.io", 80);
    if(errConnect!=0) {
        printf("\r\ncould not connect to socket; error = %d\r\n", errConnect);
    } else {
        printf("socket connected\r\n");
    }

    // get the last 2 bytes of the mac for the thing name
    std::string macString = mac;
    macString.erase(0,9);
    macString.erase(2,1);
    macString.erase(4,1);
    const char *macBytes = macString.c_str();
    
    humidity_sensor->ReadID(&id);
    pressure_sensor->ReadID(&id);
    magnetometer->ReadID(&id);
    gyroscope->ReadID(&id);
    wait(3);

    while(1) {
       
        std::string readings = "";
        temp_sensor1->GetTemperature(&value1);
        humidity_sensor->GetHumidity(&value2);
        
        readings = readings + "&temperature1=";
        readings = readings + printDouble(buffer1,value1);
        readings = readings + "&humidity=";
        readings = readings + printDouble(buffer2,value2);
                
        temp_sensor2->GetFahrenheit(&value1);
        pressure_sensor->GetPressure(&value2);
        
        readings = readings + "&temperature2=";
        readings = readings + printDouble(buffer1,value1);
        readings = readings + "&pressure=";
        readings = readings + printDouble(buffer2,value2);
        
        char magBuff[64] = "";
        magnetometer->Get_M_Axes(axes);
        sprintf(magBuff, "&magnometer0=%ld&magnometer1=%ld&magnometer2=%ld", axes[0], axes[1], axes[2]);
        readings = readings + magBuff;      
        
        char accBuff[64] = "";
        accelerometer->Get_X_Axes(axes);
        sprintf(accBuff, "&accelerometer0=%ld&accelerometer1=%ld&accelerometer2=%ld", axes[0], axes[1], axes[2]);
        readings = readings + accBuff;          
        
        char gyroBuff[64] = "";
        gyroscope->Get_G_Axes(axes);
        sprintf(gyroBuff, "&gyroscope0=%ld&gyroscope1=%ld&gyroscope2=%ld", axes[0], axes[1], axes[2]);
        readings = readings + gyroBuff;
        
        // printf(readings.c_str());
          
        panel_voltage = analog_input_A0.read();
        // printf("voltage:  %f\r\n", panel_voltage);
        
        // A0 is voltage tolerant to 3.3V, and analog read returns a percentage of the maximum
        // need to convert the percentage back to a representative number
        panel_voltage = panel_voltage * 3300; // change the value to be in the 0 to 3300 range
        // printf("a0 reads %.3f mV\n", panel_voltage); // use 3 decimals of precision
        
        // enable LED if voltage exceeds 2000 mV
        if (panel_voltage > 2000) { 
            myLed = 1;
        } 
        else {
            myLed = 0;
        }
        
        // don't bother if never connected ...        
        if (spwfResponse == 1) {    
            // get length of jsonContent as string without streams 
            // adapted from http://codereview.stackexchange.com/questions/51270/socket-http-post-request
            
            char dweetBuffer[512] = "";
            
            // create GET HTTP header for dweeting
            strcpy(dweetBuffer, "GET /dweet/for/nucleo-");     
            // uncomment to use the last 6 digits of WiFi MAC
            strcat(dweetBuffer, macBytes);
            char valueRead[16];
            sprintf(valueRead, "?a0=%f", panel_voltage);
            strcat(dweetBuffer, valueRead);
            strcat(dweetBuffer, readings.c_str());
            strcat(dweetBuffer, " HTTP/1.1\r\n\r\n"); 
                       
            serial_port.printf("\r\n%s", dweetBuffer);

            char bufferRx[1024] = "";
            int countRx = 0;
            serial_port.printf("sending and receiving data ...\r\n");
            errSend = socket.send(dweetBuffer, strlen(dweetBuffer));
            countRx = socket.recv(bufferRx, sizeof bufferRx);
            printf("sent %d bytes and received %d bytes\r\n\r\n", errSend, countRx);
            printf(bufferRx);
            printf("\r\n\r\n*** 5-second pause ...\r\n\r\n");
        }
        wait(5.0); // 5000 ms delay before looping to next read
    }
}
