// read analog0 and send to thingspace.io
// toma 2016-11-01

#include "mbed.h"
#include "stdio.h"
#include "SpwfInterface.h"
#include "TCPSocket.h"
#include <string>

/*************************************
//FRDM-K64: D9->UART1_TX, D7->UART1_RX
Pin connections:
    FRDM      IDW01M1
   ------    ---------
    +3v3 <--> +3v3
    GND  <--> GND
    D9   <--> D8
    D7   <--> D2

SpwfSAInterface spwf(D9, D7, false);
*************************************/
/*************************************
//LPCXpresso11U68: D9->UART1_TX, D7->UART1_RX
Pin connections:
    LPC      IDW01M1
   ------    ---------
    +3v3 <--> +3v3
    GND  <--> GND
    A1   <--> D8
    A2   <--> D2

SpwfSAInterface spwf(A1, A2, false);
*************************************/

//NUCLEO: D8->UART1_TX (PA_9), D2->UART1_RX (PA_10)

using namespace std;

AnalogIn analog_input_A0(A0);
Serial serial_port(USBTX, USBRX);
DigitalOut myLed(LED1);
SpwfSAInterface spwf(D8, D2, false);

int errConnect;
int errSend;

int main()
{
    float panel_voltage;
    DigitalOut led(LED1);
    serial_port.baud(9600);
    
    printf("\r\n\r\n*** system restart");
    printf("\r\n\r\nanalog0 example using thingspace.io ...\n");
    
    char *ssid = "";
    char *seckey = "";
    const char *mac;
        
    printf("X-NUCLEO-IDW01M1v2 mbed application\r\n");     
        
    int spwfResponse;
    spwfResponse = 0;
    
    while(spwfResponse != 1) {
        printf("connecting to access point ...\r\n");
        spwfResponse = spwf.connect(ssid, seckey, NSAPI_SECURITY_WPA2);//WPA
        printf("\nresponse:  %i\n", spwfResponse);
        if(spwfResponse != 1)
        {
            printf("error making connecting to access point\r\n");
        }
        else
        {
            printf("success connecting to access point\r\n");
            const char *ip = spwf.get_ip_address();
            mac = spwf.get_mac_address();
            printf("\r\nip address = %s\r\n", (ip) ? ip : "error getting ip address");
            printf("mac address = %s\r\n", (mac) ? mac : "error getting the mac address\n");
        }
    }
    
    SocketAddress addrDweetServer(&spwf, "thingspace.io");
    printf("\r\nthingspace.verizon.com resolved to: %s\r\n\r\n", addrDweetServer.get_ip_address());

    TCPSocket socket(&spwf);

    // connect socket
    errConnect = socket.connect("thingspace.io", 80);
    if(errConnect!=0) {
        printf("\r\ncould not connect to socket; error = %d\r\n", errConnect);
    } else {
        printf("socket connected\r\n");
    }

    // get the last 2 bytes of the mac for the thing name
    std::string macString = mac;
    macString.erase(0,9);
    macString.erase(2,1);
    macString.erase(4,1);
    const char *macBytes = macString.c_str();

    while(1) {
        panel_voltage = analog_input_A0.read();
        printf("voltage:  %f\r\n", panel_voltage);
        // A0 is voltage tolerant to 3.3V, and analog read returns a percentage of the maximum
        // need to convert the percentage back to a representative number
        panel_voltage = panel_voltage * 3300; // change the value to be in the 0 to 3300 range
        // printf("a0 reads %.3f mV\n", panel_voltage); // use 3 decimals of precision
        
        // enable LED if voltage exceeds 2000 mV
        if (panel_voltage > 2000) { 
            myLed = 1;
        } 
        else {
            myLed = 0;
        }
        
        // don't bother if never connected ...        
        if (spwfResponse == 1) {    
            // get length of jsonContent as string without streams 
            // adapted from http://codereview.stackexchange.com/questions/51270/socket-http-post-request
            
            char dweetBuffer[72] = "";
            
            // create GET HTTP header for dweeting
            strcpy(dweetBuffer, "GET /dweet/for/nucleo-");     
            strcat(dweetBuffer, macBytes);    
            char valueRead[20];
            sprintf(valueRead, "?voltage=%f", panel_voltage);
            strcat(dweetBuffer, valueRead);
            strcat(dweetBuffer, " HTTP/1.1\r\n\r\n"); 
                       
            serial_port.printf("\r\n%s", dweetBuffer);

            char bufferRx[512] = "";
            int countRx = 0;
            serial_port.printf("sending and receiving data ...\r\n");
            errSend = socket.send(dweetBuffer, strlen(dweetBuffer));
            countRx = socket.recv(bufferRx, sizeof bufferRx);
            printf("sent %d bytes\r\nand received %d bytes\r\n\r\n", errSend, countRx);
            printf(bufferRx);
            printf("\r\n\r\n*** 5-second pause ...\r\n");
        }
        wait(5.0); // 5000 ms delay before looping to next read
    }
}
