//program design practice
//mbed program
//use Standard LCD  #define STD_LCD
//use I2C LCD   #define I2C_LCD
//**need Inport TextLCD, ACM1602NI.cpp, ACM1602NI.h
//
#include "mbed.h"

#define STD_LCD

#ifdef STD_LCD
    #include "TextLCD.h"
    TextLCD lcd(p27,p28,p26,p29,p25,p30);   // rs,e, d4,d5,d6,d7
#endif
#ifdef I2C_LCD
    #include "ACM1602NI.h"
    ACM1602NI lcd(p28, p27); //sda scl
#endif

Ticker flipper;
DigitalOut led1(p21);
DigitalOut led2(p22);
DigitalOut led3(p23);
DigitalOut led4(p24);
DigitalIn  sw1(p14);
DigitalIn  sw2(p15);
DigitalIn  sw3(p16);
AnalogIn   vr(p17);
Serial pc(USBTX, USBRX); // tx, rx

unsigned char cnt;
char msg1[] = "S1:0 S2:0 S3:0";
char msg2[] = "  511  1010";
char msg3[] = "    ";
char StBuf[5];
char SendBuf[17];
int  flg_rdet, recv_cnt;
int vrad;

void Cnv210(int val)
{
     unsigned char temp;
     int i;
     StBuf[0] = StBuf[1] = StBuf[2] = StBuf[3] = StBuf[4] = ' ';
     i = 0;
    do {
            temp = val % 10;
            StBuf[i++] = temp + '0';
        } while (( val /= 10 ) != 0 );
}

void rxRecieve()
{
    char ch;  
    
    ch = pc.getc();
    if ( flg_rdet == 0 ) {
        if ( ch == 'r' ) {
            flg_rdet = 1;
            recv_cnt = 5;
        }
    }
    if ( flg_rdet == 1 ) {
        switch ( recv_cnt ) {
            case 0:
                msg3[0] = ch;
                recv_cnt = 1;
                break;
            case 1:
                msg3[1] = ch;
                recv_cnt = 2;
                break;
            case 2:
                msg3[2] = ch;
                recv_cnt =3;
                break;
            case 3:
                msg3[3] = ch;
                recv_cnt = 0;
                flg_rdet = 0;
                lcd.locate(12,1);
                lcd.printf(msg3);
                break;
            default:
                recv_cnt = 0;
                break;

        }
    }
}
  
void flip() {
    if((cnt & 0x8) == 0) led4= 0;
    else led4 = 1;
    if((cnt & 0x4) == 0) led3= 0;
    else led3 = 1;
    if((cnt & 0x2) == 0) led2= 0;
    else led2 = 1;
    if((cnt & 0x1) == 0) led1= 0;
    else led1 = 1;
    
    if(!sw1 == 0) msg1[3] = '0';
    else msg1[3] = '1';
    if(!sw2 == 0) msg1[8] = '0';
    else msg1[8] = '1';
    if(!sw3 == 0) msg1[13] = '0';
    else msg1[13] = '1';
    
    if(!led4 == 0) msg2[7] = '1';
    else msg2[7] = '0';
    if(!led3 == 0) msg2[8] = '1';
    else msg2[8] = '0';
    if(!led2 == 0) msg2[9] = '1';
    else msg2[9] = '0';
    if(!led1 == 0) msg2[10] = '1';
    else msg2[10] = '0';
    
    vrad = (int)(vr.read() * 1023);
    Cnv210(vrad);
    msg2[0] = StBuf[4];
    msg2[1] = StBuf[3];
    msg2[2] = StBuf[2];
    msg2[3] = StBuf[1];
    msg2[4] = StBuf[0];
;
    
    lcd.locate(0,0);
    lcd.printf(msg1);
    
    lcd.locate(0,1);
    lcd.printf(msg2);
    SendBuf[2] = StBuf[4];
    SendBuf[3] = StBuf[3];
    SendBuf[4] = StBuf[2];
    SendBuf[5] = StBuf[1];
    SendBuf[6] = StBuf[0];
    
    SendBuf[7] = msg2[10];
    SendBuf[8] = msg2[9];
    SendBuf[9] = msg2[8];
    SendBuf[10] = msg2[7];
    
    SendBuf[11] = msg1[3];
    SendBuf[12] = msg1[8];
    SendBuf[13] = msg1[13];
    pc.printf(SendBuf);
    cnt++;
    if(cnt == 16) cnt = 0;
}

int main() {
    pc.baud(38400);
    cnt = 0;
    sw1.mode(PullUp);
    sw2.mode(PullUp);
    sw3.mode(PullUp);
    lcd.cls();
    lcd.printf(msg1);
    lcd.locate(0,1);
    lcd.printf(msg2);
    pc.printf("Serial Communication Start\n");
    SendBuf[0] = 'C';
    SendBuf[1] = 'S';
    SendBuf[14] = '\r';
    SendBuf[15] = '\n';
    SendBuf[16] = 0x00;
    flg_rdet = 0;
    recv_cnt = 0;
    flipper.attach(&flip, 0.75); // the address of the function to be attached (flip) and the interval (2 seconds)
    pc.attach(rxRecieve, Serial::RxIrq);
    while (1) {       
    }
}