//mbedSwTone
// tact Swtitch is pushed then output Beep tone from Piezoelectric speaker 
//
//
//
#include "mbed.h"

//define sw ports
DigitalIn k1(p13);
DigitalIn k2(p15);
DigitalIn k3(p14);
DigitalIn k4(p17);
DigitalIn k5(p18);
DigitalIn k6(p19);
DigitalIn k7(p10);
DigitalIn k8(p20);
DigitalIn k9(p9);
DigitalIn k10(p7);
DigitalIn k11(p8);
DigitalIn k12(p6);
DigitalIn k13(p5);
DigitalIn k14(p22);
DigitalIn k15(p21);
DigitalIn k16(p23);
DigitalIn k17(p24);
DigitalIn k18(p25);
DigitalIn k19(p29);
DigitalIn k20(p27);
DigitalIn k21(p30);
DigitalIn k22(p28);

#define SW_N 22//number of key switches
PwmOut speaker(p26);

DigitalOut led(p11);

//switch status 0:off, 1:posEdge, 2:on, 3:negEdge
int sw_st[SW_N];

//period array
int p[SW_N]={
1912,
1805,
1703,
1608,
1518,
1432,
1352,
1276,
1205,
1137,
1073,
1013,
956,
902,
852,
804,
759,
716,
676,
638,
602,
568
};

void chksw(void)
{
    static int ssw[SW_N], psw[SW_N], cnt[SW_N], tcnt[SW_N];
    int i;

    psw[0] = k1;
    psw[1] = k2;
    psw[2] = k3;
    psw[3] = k4;
    psw[4] = k5;
    psw[5] = k6;
    psw[6] = k7;
    psw[7] = k8;
    psw[8] = k9;
    psw[9] = k10;
    psw[10] = k11;
    psw[11] = k12;
    psw[12] = k13;
    psw[13] = k14;
    psw[14] = k15;
    psw[15] = k16;
    psw[16] = k17;
    psw[17] = k18;
    psw[18] = k19;
    psw[19] = k20;
    psw[20] = k21;
    psw[21] = k22;

//switch status 0:off, 1:posEdge, 2:on, 3:negEdge
    for(i = 0; i < SW_N; i++){
        if((ssw[i] == 0)&&(psw[i] == 0)){
            sw_st[i] = 2;//on
            tcnt[i] ++;
        }
        if((ssw[i] == 0)&&(psw[i] == 1)){
            sw_st[i] = 3;//negEdge
            cnt[i] = tcnt[i];
        }
        if((ssw[i] == 1)&&(psw[i] == 1)){
            sw_st[i] = 0;//off
            tcnt[i] ++;
        }
        if((ssw[i] == 1)&&(psw[i] == 0)){
            sw_st[i] = 1;//posEdge
            cnt[i] = tcnt[i];
        }
        ssw[i] = psw[i];
    }
}

void beepon(int i)
{
    speaker.period_us(p[i]);//change period 
    speaker.write(0.5);//duty = 50% -> on
}

void beepoff(int i)
{
    speaker.write(0);//duty = 0% -> off
}

void beep(void)
{
    int i;
    for(i = 0; i < SW_N; i++){
        if(sw_st[i] == 1){//Positive edge
            beepon(i);
            led = 1;
        }
        if(sw_st[i] == 3){//Negative edge
            beepoff(i);
            led = 0;
        }
    }
}

int main() {
//    speaker.pulsewidth(0.5);
    k1.mode(PullUp);
    k2.mode(PullUp);
    k3.mode(PullUp);
    k4.mode(PullUp);
    k5.mode(PullUp);
    k6.mode(PullUp);
    k7.mode(PullUp);
    k8.mode(PullUp);
    k9.mode(PullUp);
    k10.mode(PullUp);
    k11.mode(PullUp);
    k12.mode(PullUp);
    k13.mode(PullUp);
    k14.mode(PullUp);
    k15.mode(PullUp);
    k16.mode(PullUp);
    k17.mode(PullUp);
    k18.mode(PullUp);
    k19.mode(PullUp);
    k20.mode(PullUp);
    k21.mode(PullUp);
    k22.mode(PullUp);
    while(1) {
        chksw();
        beep();
    }
}
