//mbed program
//serial port 
#include "mbed.h"

#include "ACM1602NI.h"
ACM1602NI lcd(p28, p27); //sda scl

Ticker flipper;
DigitalOut led1(p21);
DigitalOut led2(p22);
DigitalOut led3(p23);
DigitalOut led4(p24);
DigitalIn  sw1(p14);
DigitalIn  sw2(p15);
DigitalIn  sw3(p16);
AnalogIn   vr(p17);
BusOut leds(p21,p22,p23,p24,p25,p26);
Serial pc(USBTX, USBRX); // tx, rx

unsigned char cnt;
char msg1[] = "S:123 ";
char msg2[] = "RD:";
int vrad;

void rxRecieve()
{
    char ch;  
    
    ch = pc.getc();
    
    lcd.locate(3,1);
    lcd.printf("%c", ch);
}
  
void flip() {
    if(!sw1 == 0) msg1[2] = '0';
    else msg1[2] = '1';
    if(!sw2 == 0) msg1[3] = '0';
    else msg1[3] = '1';
    if(!sw3 == 0) msg1[4] = '0';
    else msg1[4] = '1';
    
    leds = cnt;
    
    vrad = (int)(vr.read() * 1023);

    lcd.locate(0,0);
    lcd.printf(msg1);
    lcd.locate(6,0);
    lcd.printf("AD:%4d", vrad);
    
    lcd.locate(0,1);
    lcd.printf(msg2);

    pc.printf("%4d ", cnt);
    pc.printf(msg1);
    pc.printf("AD:%4d\n\r", vrad);

    cnt++;
    if(cnt == 64) cnt = 0;
}

int main() {
    pc.baud(38400);
    cnt = 0;
    sw1.mode(PullUp);
    sw2.mode(PullUp);
    sw3.mode(PullUp);
    lcd.cls();
    pc.printf("Serial Communication Start\n\r");
    flipper.attach(&flip, 0.1); // the address of the function to be attached (flip) and the interval (2 seconds)
    pc.attach(rxRecieve, Serial::RxIrq);
    while (1) {       
    }
}