#define CPP1 1
#define C1 0

#if CPP1
//SD card check program C++ version
#include "mbed.h"
#include "SDFileSystem.h"
#include "ACM1602NI.h"
DigitalOut led1(p21);
DigitalOut led2(p22);
DigitalOut led3(p23);
DigitalOut led4(p24);
DigitalOut led5(p25);
DigitalOut led6(p26);
//DigitalIn  sw1(p14);
//DigitalIn  sw2(p15);
//DigitalIn  sw3(p16);
AnalogIn   vr(p17);

FILE *fp;
SDFileSystem sd(p5, p6, p7, p8, "sd"); // the pinout on the mbed Cool Components workshop board
ACM1602NI lcd(p28, p27); //sda scl

class cChkSw
{
public:
    int st[3];
    int counter[3];//past counter
    cChkSw(PinName, PinName, PinName);
    DigitalIn *sw1;
    DigitalIn *sw2;
    DigitalIn *sw3;
    void init();
    void chksw();
    
protected:
};

void cChkSw::init()
{
}

cChkSw::cChkSw(PinName s1, PinName s2, PinName s3)
{
    //Create instance SW1,SW2,SW3
    sw1 = new DigitalIn(s1);
    sw2 = new DigitalIn(s2);
    sw3 = new DigitalIn(s3);
    //All SW pin set Pull Up
    sw1->mode(PullUp);
    sw2->mode(PullUp);
    sw3->mode(PullUp);
}

void cChkSw::chksw()
//switch status 0:off, 1:posEdge, 2:on, 3:negEdge
{
    static int ssw[3], psw[3], cnt[3], tcnt[3];
    int i;
    psw[0] = sw1->read();
    psw[1] = sw2->read();
    psw[2] = sw3->read();
//switch status 0:off, 1:posEdge, 2:on, 3:negEdge
    for(i = 0; i < 3; i++){
        if((ssw[i] == 0)&&(psw[i] == 0)){
            st[i] = 2;//on
            tcnt[i] ++;
            counter[i] = tcnt[i];
        }
        if((ssw[i] == 0)&&(psw[i] == 1)){
            st[i] = 3;//negEdge
            cnt[i] = tcnt[i];
            tcnt[i] = 0;
            counter[i] = tcnt[i];
        }
        if((ssw[i] == 1)&&(psw[i] == 1)){
            st[i] = 0;//off
            tcnt[i] ++;
        }
        if((ssw[i] == 1)&&(psw[i] == 0)){
            st[i] = 1;//posEdge
            cnt[i] = tcnt[i];
            tcnt[i] = 0;
            counter[i] = tcnt[i];
        }
        ssw[i] = psw[i];
    }
}

int main() {
    char str[80];

    lcd.cls();
    lcd.locate(0,0);
    lcd.printf("SD Card chkpgm");   
    lcd.locate(0,1);
 
//    mkdir("/sd/mydir", 0777);
    led1=led2=led3=led4=led5=led6 = 0;
    int counter = 0;

    cChkSw cs(p14,p15,p16);
    while(1){
        cs.chksw();
        led6 = 1; 
        
        if(cs.st[0] == 1){
            led1=led2=led3=led4=led5=led6 = 0;
            led4 = 1;
            counter++;
            FILE *fp = fopen("/sd/sdtest.txt", "w");
            if(fp == NULL) {
                error("Could not open file for write\n");
                led2 = 1;
            }else{
                fprintf(fp, "SDcard#%d\n", counter);
                fclose(fp);
                lcd.locate(0,1);
                lcd.printf("                ");
                lcd.locate(0,1);
                lcd.printf("counter = %d", counter);
                led1 = 1; 
            }
        }
        if(cs.st[1] == 1){
            led1=led2=led3=led4=led5=led6 = 0;
            led5 = 1;    
            fp = fopen("/sd/sdtest.txt", "r");
            if(fp == NULL) {
                error("Could not open file for write\n\r");
                led2 = 1;
            }else{
                fscanf(fp, "%s\n", str);//read from SD card
                lcd.locate(0,1);
                lcd.printf("               ");//output string to LCD
                lcd.locate(0,1);
                lcd.printf("text = %s", str);//output string to USB serial
                fclose(fp);
                led1 = 1; 
            }
        }
        if(cs.st[2] == 1){
            led1=led2=led3=led4=led5=led6 = 0;
            led6 = 1; 
            counter = 0;
            lcd.locate(0,1);
            lcd.printf("                ");
        }
    }
}
#endif

#if C1
//SD card check program C version
//
//
//
#include "mbed.h"
#include "SDFileSystem.h"
#include "ACM1602NI.h"

DigitalOut led1(p21);
DigitalOut led2(p22);
DigitalOut led3(p23);
DigitalOut led4(p24);
DigitalOut led5(p25);
DigitalOut led6(p26);
//Create instance SW1,SW2,SW3
DigitalIn  sw1(p14);
DigitalIn  sw2(p15);
DigitalIn  sw3(p16);
AnalogIn   vr(p17);

FILE *fp;
SDFileSystem sd(p5, p6, p7, p8, "sd"); // the pinout on the mbed Cool Components workshop board
ACM1602NI lcd(p28, p27); //sda scl

//switch status 0:off, 1:posEdge, 2:on, 3:negEdge
int sw_st[3];
int sw_cnt[3];//past counter

void chksw(void)
{
    static int ssw[3], psw[3], cnt[3], tcnt[3];
    int i;
    psw[0] = sw1;
    psw[1] = sw2;
    psw[2] = sw3;
//switch status 0:off, 1:posEdge, 2:on, 3:negEdge
    for(i = 0; i < 3; i++){
        if((ssw[i] == 0)&&(psw[i] == 0)){
            sw_st[i] = 2;//on
            tcnt[i] ++;
            sw_cnt[i] = tcnt[i];
        }
        if((ssw[i] == 0)&&(psw[i] == 1)){
            sw_st[i] = 3;//negEdge
            cnt[i] = tcnt[i];
            tcnt[i] = 0;
            sw_cnt[i] = tcnt[i];
        }
        if((ssw[i] == 1)&&(psw[i] == 1)){
            sw_st[i] = 0;//off
            tcnt[i] ++;
        }
        if((ssw[i] == 1)&&(psw[i] == 0)){
            sw_st[i] = 1;//posEdge
            cnt[i] = tcnt[i];
            tcnt[i] = 0;
            sw_cnt[i] = tcnt[i];
        }
        ssw[i] = psw[i];
    }
}

int main() {
    char str[80];
    
//All SW pin set Pull Up
    sw1.mode(PullUp);
    sw2.mode(PullUp);
    sw3.mode(PullUp);
    
    lcd.cls();
    lcd.locate(0,0);
    lcd.printf("SD Card chkpgm");   
    lcd.locate(0,1);
 
//    mkdir("/sd/mydir", 0777);
    led1=led2=led3=led4=led5=led6 = 0;
    int counter = 0;

    while(1){
        chksw();
        led6 = 1; 
        if(sw_st[0] == 1){
            led1=led2=led3=led4=led5=led6 = 0;
            led4 = 1;
            counter++;
            FILE *fp = fopen("/sd/sdtest.txt", "w");
            if(fp == NULL) {
                error("Could not open file for write\n");
                led2 = 1;
            }else{
                fprintf(fp, "SDcard#%d\n", counter);
                fclose(fp);
                lcd.locate(0,1);
                lcd.printf("                ");
                lcd.locate(0,1);
                lcd.printf("counter = %d", counter);
                led1 = 1; 
            }
        }
        if(sw_st[1] == 1){
            led1=led2=led3=led4=led5=led6 = 0;
            led5 = 1;    
            fp = fopen("/sd/sdtest.txt", "r");
            if(fp == NULL) {
                error("Could not open file for write\n\r");
                led2 = 1;
            }else{
                fscanf(fp, "%s\n", str);//read from SD card
                lcd.locate(0,1);
                lcd.printf("               ");//output string to LCD
                lcd.locate(0,1);
                lcd.printf("text = %s", str);//output string to USB serial
                fclose(fp);
                led1 = 1; 
            }
        }
        if(sw_st[2] == 1){
            led1=led2=led3=led4=led5=led6 = 0;
            led6 = 1; 
            counter = 0;
            lcd.locate(0,1);
            lcd.printf("                ");
        }
    }
}
#endif
