#if 1
/*
 * spp_demo
 VS-02 android remotecontroler application
 mbed LED1,LED2,LED3,LED4 on/off control
 serial baudrate = 921600,8bit,stop 1bit,none parity
 */
//mbed pin layout
//1   GND
//2   
//3   
//4   
//5   SD SDI
//6   SD SDO
//7   SD SCK
//8   SD CS
//9   I2C sda
//10  I2C sci
//11  SPI mosi
//12  SPI miso
//13  SPI sck
//14  SW0
//15  SW1
//16  SW2
//17  Vr
//18  D/A
//19  Ain1
//20  
//21  PWMOut1
//22  PWMOut2
//23  PWMOut3
//24  PWMOut4
//25  PWMOut5
//26  PWMOut6
//27  LCD scl : ACM1602NI-4(ACM1602NI 1Vss,2Vdd,3Vo,4SCL,5SDA,6LED+,7LED-)
//28  LCD sda : ACM1602NI-5
//29  
//30  
//31  USB D+
//32  USB D-
//
/*
0   1   2   3   4   5   6   7   8   9   10  11  12  13  14  15
0   0   0   0   1       S0  S1  S2      1   0   2   3   "LeftArrow" "RightArrow"
1                                                               
*/

#include "mbed.h"
#include <btstack/hci_cmds.h>
#include <btstack/run_loop.h>
#include <btstack/sdp_util.h>
#include "hci.h"
#include "l2cap.h"
#include "btstack_memory.h"
#include "remote_device_db.h"
#include "rfcomm.h"
extern "C" {
#include "sdp.h"
}
#include "config.h"
#include "debug.h"
#include "bd_addr.h"  // class bd_addr

#include "ACM1602NI.h"
//#include "SDFileSystem.h"

Serial pc(USBTX, USBRX);

DigitalOut brd_led1(LED1), brd_led2(LED2), brd_led3(LED3), brd_led4(LED4);

DigitalOut led1(p21);
DigitalOut led2(p22);
DigitalOut led3(p23);
DigitalOut led4(p24);
DigitalOut led5(p25);
DigitalOut led6(p26);
DigitalIn  sw1(p14);
DigitalIn  sw2(p15);
DigitalIn  sw3(p16);
AnalogIn   vr(p17);

/*
SDFileSystem *Sd;
FILE *fp;
*/

static Timer timer;
static int VSC2btn[20];//VS-C2 button push then 1, other 0
//0:left arrow up  
//1:left arrow right
//2:left arrow down
//3:left arrow left
//4:right arrow up
//5:right arrow right
//6:right arrow down
//7:right arrow left
//8:select
//9:start
    static int module_status = 0;//0 timer set mode, 1 timer run mode, 2 timer complete
    static int time_cnt = 0;//use run mode timer counter
    static int time_set = 0;//use set mode timer counter


//LCD class
ACM1602NI lcd(p28, p27); //sda scl

#define HEARTBEAT_PERIOD_MS 100

static uint8_t   rfcomm_channel_nr = 1;
static uint16_t  rfcomm_channel_id = 0;
static uint8_t   spp_service_buffer[128];

static void data_recv(uint8_t *packet, uint16_t size);

// Bluetooth logic
static void packet_handler (void * connection, uint8_t packet_type, uint16_t channel, uint8_t *packet, uint16_t size){
    bd_addr_t event_addr;
    uint8_t   rfcomm_channel_nr;
    uint16_t  mtu;
    int err;
    switch (packet_type) {
        case HCI_EVENT_PACKET:
            switch (packet[0]) {
                    
                case BTSTACK_EVENT_STATE:
                    // bt stack activated, get started - set local name
                    if (packet[2] == HCI_STATE_WORKING) {
                        hci_send_cmd(&hci_write_local_name, "mbed seminar");
                    }
                    break;
                
                case HCI_EVENT_COMMAND_COMPLETE:
                    if (COMMAND_COMPLETE_EVENT(packet, hci_read_bd_addr)){
                        bt_flip_addr(event_addr, &packet[6]);
                        log_info("BD-ADDR: %s\n\r", bd_addr_to_str(event_addr));
                        break;
                    }
                    if (COMMAND_COMPLETE_EVENT(packet, hci_write_local_name)){
                        hci_discoverable_control(1);
                        break;
                    }
                    break;

                case HCI_EVENT_LINK_KEY_REQUEST:
                    // deny link key request
                    log_info("Link key request\n\r");
                    bt_flip_addr(event_addr, &packet[2]);
                    hci_send_cmd(&hci_link_key_request_negative_reply, &event_addr);
                    break;
                    
                case HCI_EVENT_PIN_CODE_REQUEST:
                    // inform about pin code request
                    log_info("Pin code request - using '0000'\n\r");
                    bt_flip_addr(event_addr, &packet[2]);
                    hci_send_cmd(&hci_pin_code_request_reply, &event_addr, 4, "0000");
                    break;
                
                case RFCOMM_EVENT_INCOMING_CONNECTION:
                    // data: event (8), len(8), address(48), channel (8), rfcomm_cid (16)
                    bt_flip_addr(event_addr, &packet[2]); 
                    rfcomm_channel_nr = packet[8];
                    rfcomm_channel_id = READ_BT_16(packet, 9);
                    log_info("RFCOMM channel %u requested for %s\n\r", rfcomm_channel_nr, bd_addr_to_str(event_addr));
                    rfcomm_accept_connection_internal(rfcomm_channel_id);
                    break;
                    
                case RFCOMM_EVENT_OPEN_CHANNEL_COMPLETE:
                    // data: event(8), len(8), status (8), address (48), server channel(8), rfcomm_cid(16), max frame size(16)
                    if (packet[2]) {
                        log_info("RFCOMM channel open failed, status %u\n\r", packet[2]);
                    } else {
                        rfcomm_channel_id = READ_BT_16(packet, 12);
                        mtu = READ_BT_16(packet, 14);
                        log_info("\n\rRFCOMM channel open succeeded. New RFCOMM Channel ID %u, max frame size %u\n\r", rfcomm_channel_id, mtu);
                    }
                    break;
                    
                case RFCOMM_EVENT_CHANNEL_CLOSED:
                    rfcomm_channel_id = 0;
                    break;
                
                default:
                    break;
            }
            break;
            
        case RFCOMM_DATA_PACKET:
            // loopback
            if (rfcomm_channel_id) {
                err = rfcomm_send_internal(rfcomm_channel_id, packet, size);
                if (err) {
                    log_info("rfcomm_send_internal -> error %d", err);
                }
            }
            
            data_recv(packet, size);
            
//            led3 = !led3;
            break;
        default:
            break;
    }
}

static void data_recv(uint8_t *packet, uint16_t size){
    int i;
    static int timerp[12];
    static int timers[12];
//    char ind[4];
    log_info("packet(size:%d) = ", size);

//recive char display mode
//for analys recieve char
//    for (i = 0; i < size; i++){
//        log_info("%c", packet[i]);
//    }
//    log_info("\n\r");


//VS-02 remote controler corss key
//packet
//  9 right arrow: 1 up(triangle), 2 right(circle), 4 down(closs), 8 left(quad)
// 10 L R Button : 1 L2, 2 R2, 4 L1, 8 R1
// 12 left arrow: 1 up, 2 right, 4 down, 8 left
// 13 1 select, 2 R3, 4 L3, 8 start
    if(packet[0] == 'w'){
        log_info("%c", packet[9]);
        log_info("%c", packet[10]);
        log_info("%c", packet[12]);
        log_info("%c", packet[13]);
        switch (packet[9]) {
            case '1':
                timers[4] = timerp[4];
                timerp[4] = timer.read_ms();
                log_info("%d", timerp[4]-timers[4]);
                if((timerp[4]-timers[4])>150){
                    VSC2btn[4]=1;
                }
                break;
            case '2':
                timers[5] = timerp[5];
                timerp[5] = timer.read_ms();
                log_info("%d", timerp[5]-timers[5]);
                if((timerp[5]-timers[5])>150){
                    VSC2btn[5]=1;
                }
                break;
            case '4':
                timers[6] = timerp[6];
                timerp[6] = timer.read_ms();
                log_info("%d", timerp[6]-timers[6]);
                if((timerp[6]-timers[6])>150){
                    VSC2btn[6]=1;
                }
                break;
            case '8':
                timers[7] = timerp[7];
                timerp[7] = timer.read_ms();
                log_info("%d", timerp[7]-timers[7]);
                if((timerp[7]-timers[7])>150){
                    VSC2btn[7]=1;
                }
                break;
            case '0':
                VSC2btn[4]=0;
                VSC2btn[5]=0;
                VSC2btn[6]=0;
                VSC2btn[7]=0;
                break;
            
        }
        switch (packet[12]) {
            case '1':
                timers[0] = timerp[0];
                timerp[0] = timer.read_ms();
                log_info("%d", timerp[0]-timers[0]);
                if((timerp[0]-timers[0])>150){
                    VSC2btn[0]=1;
                }
                break;
            case '2':
                timers[1] = timerp[1];
                timerp[1] = timer.read_ms();
                log_info("%d", timerp[1]-timers[1]);
                if((timerp[1]-timers[1])>150){
                    VSC2btn[1]=1;
                }
                break;
            case '4':
                timers[2] = timerp[2];
                timerp[2] = timer.read_ms();
                log_info("%d", timerp[2]-timers[2]);
                if((timerp[2]-timers[2])>150){
                    VSC2btn[2]=1;
                }
                break;
            case '8':
                timers[3] = timerp[3];
                timerp[3] = timer.read_ms();
                log_info("%d", timerp[3]-timers[3]);
                if((timerp[3]-timers[3])>150){
                    VSC2btn[3]=1;
                }
                break;
            case '0':
                VSC2btn[0]=0;
                VSC2btn[1]=0;
                VSC2btn[2]=0;
                VSC2btn[3]=0;
                break;
        }
        switch (packet[13]) {
            case '1':
                timers[8] = timerp[8];
                timerp[8] = timer.read_ms();
                log_info("%d", timerp[8]-timers[8]);
                if((timerp[8]-timers[8])>150){
                    VSC2btn[8]=1;
                }
                break;
            case '8':
                timers[9] = timerp[9];
                timerp[9] = timer.read_ms();
                log_info("%d", timerp[9]-timers[9]);
                if((timerp[9]-timers[9])>150){
                    VSC2btn[9]=1;
                }
                break;
            case '0':
                VSC2btn[8]=0;
                VSC2btn[9]=0;
                break;
        }
//
//
        
    }
    log_info("\n\r");
}

//switch status 0:off, 1:posEdge, 2:on, 3:negEdge
int sw_st[3];
int sw_cnt[3];//past counter

void chksw(void)
{
    static int ssw[3], psw[3], cnt[3], tcnt[3];
    int i;
    psw[0] = sw1;
    psw[1] = sw2;
    psw[2] = sw3;
//switch status 0:off, 1:posEdge, 2:on, 3:negEdge
    for(i = 0; i < 3; i++){
        if((ssw[i] == 0)&&(psw[i] == 0)){
            sw_st[i] = 2;//on
            tcnt[i] ++;
            sw_cnt[i] = tcnt[i];
        }
        if((ssw[i] == 0)&&(psw[i] == 1)){
            sw_st[i] = 3;//negEdge
            cnt[i] = tcnt[i];
            tcnt[i] = 0;
            sw_cnt[i] = tcnt[i];
        }
        if((ssw[i] == 1)&&(psw[i] == 1)){
            sw_st[i] = 0;//off
            tcnt[i] ++;
        }
        if((ssw[i] == 1)&&(psw[i] == 0)){
            sw_st[i] = 1;//posEdge
            cnt[i] = tcnt[i];
            tcnt[i] = 0;
            sw_cnt[i] = tcnt[i];
        }
        ssw[i] = psw[i];
    }
}


static void  heartbeat_handler(struct timer *ts){
    static int counter = 0, tmp_counter=0;
    static int c_pos = 2;//   4:32:10
                         //   0:55:00
    static char line1[20], line2[20];

    run_loop_set_timer(ts, HEARTBEAT_PERIOD_MS);
    run_loop_add_timer(ts);

    brd_led2 = !brd_led2;
    counter ++;
//    tmp_counter = time_cnt;

    if(module_status == 1){
    }
    
    if(module_status == 0){//set mode
//        int cd[5]={1,10,60,600,3600};
//        if(VSC2btn[3] == 1){//left arrow left
//            c_pos++;
//            if(c_pos == 5) c_pos=0;
//            VSC2btn[3] = 0;
//        }
//        if(VSC2btn[1] == 1){//left arrow right
//            c_pos--;
//            if(c_pos == -1) c_pos=4;
//            VSC2btn[1] = 0;
//        }
/*
        if(VSC2btn[0] == 1){//left arrow up
            time_set = time_set + cd[c_pos];
            VSC2btn[0] = 0;
        }
        if(VSC2btn[2] == 1){//left arrow down
            if(time_set - cd[c_pos]>=0){
                time_set = time_set - cd[c_pos];
            }
            VSC2btn[2] = 0;
        }
*/
        if(VSC2btn[9] == 1){//start
            time_cnt = time_set;//set time
            //relay on
            module_status = 1;
            VSC2btn[9] = 0;
        }
//        int sec=(time_set%3600)%60, min=(time_set%3600)/60, time = time_set/3600;
    }else if(module_status == 1){//run mode
//        int sec=(time_cnt%3600)%60, min=(time_cnt%3600)/60, time = time_cnt/3600;
//        strcpy(line1, "timer run mode ");
//        sprintf(line2, "%2d:%2d:%2d       ", time, min, sec);
//        if(time_cnt == 0){
//            module_status = 2;
//        }
        if(VSC2btn[6] == 1){//closs
            time_set = 0;
            module_status = 0;
            VSC2btn[6] = 0;
        }
                    
    }else if(module_status == 2){//complete
        strcpy(line1, "timer up!!      ");
        sprintf(line2, "push start");
        //relay off

        if(VSC2btn[9] == 1){//start
            module_status = 0;//
            VSC2btn[9] = 0;
        }
    }
    chksw();
    if(sw_st[0] == 1){
        led1 = 1;
    }else{
        led1 = 0;
    }
    if(sw_st[1] == 1){
        led2 = 1;
    }else{
        led2 = 0;
    }
    if(sw_st[2] == 1){
        led3 = 1;
    }else{
        led3 = 0;
    }
    if(sw_st[0] == 2){
        led4 = 1;
    }else{
        led4 = 0;
    }
    if(sw_st[1] == 2){
        led5 = 1;
    }else{
        led5 = 0;
    }
    if(sw_st[2] == 2){
        led6 = 1;
    }else{
        led6 = 0;
    }
    sprintf(line2, "%4d:%d%d%d %4d %d%d", 
    time_cnt, sw_st[0], sw_st[1], sw_st[2], (int)(vr.read() * 1023), 
    VSC2btn[0]/*left up*/, VSC2btn[2]/*left down*/ );

    {
        //display LCD
        lcd.locate(0,0);
        lcd.printf(line1);
        lcd.locate(0,1);
        lcd.printf(line2);        
    }
/*
    {
        Sd = new SDFileSystem(p5, p6, p7, p8, "sd");     
        // new sd object *** unable to draw sd card ***
        
        //write to SD card
        FILE *fp = fopen("/sdtest.txt", "w");
        if(fp == NULL) {
            error("Could not open file for write\n\r");
        }else{
            fprintf(fp, line2);
            fclose(fp); 
        }
        delete Sd;// delete object *** enable to draw sd card ***
    }
*/
} 



Ticker t1s;
void t1scall(void)
{
    if(module_status == 1){
        time_cnt ++;
    }
}

// main
int main(void)
{
    t1s.attach(&t1scall, 1);
    timer.start();
    
    pc.baud(921600);
    pc.printf("mbed BoardChk1");    
    lcd.printf("mbed BoardChk1");

    sw1.mode(PullUp);
    sw2.mode(PullUp);
    sw3.mode(PullUp);

    log_info("%s\n", __FILE__);
    // init LEDs
    brd_led1 = brd_led2 = brd_led3 = brd_led4 = 0;
    
    /// GET STARTED with BTstack ///
    btstack_memory_init();
    run_loop_init(RUN_LOOP_EMBEDDED);
    
    // init HCI
    hci_transport_t* transport = hci_transport_usb_instance();
    remote_device_db_t * remote_db = (remote_device_db_t *) &remote_device_db_memory;
    hci_init(transport, NULL, NULL, remote_db);
    
    // init L2CAP
    l2cap_init();
    l2cap_register_packet_handler(packet_handler);
    
    // init RFCOMM
    rfcomm_init();
    rfcomm_register_packet_handler(packet_handler);
    rfcomm_register_service_internal(NULL, rfcomm_channel_nr, 100);  // reserved channel, mtu=100

    // init SDP, create record for SPP and register with SDP
    sdp_init();
    memset(spp_service_buffer, 0, sizeof(spp_service_buffer));
    service_record_item_t * service_record_item = (service_record_item_t *) spp_service_buffer;
    sdp_create_spp_service( (uint8_t*) &service_record_item->service_record, 1, "loopback");
    log_info("SDP service buffer size: %u\n\r", (uint16_t) (sizeof(service_record_item_t) + de_get_len((uint8_t*) &service_record_item->service_record)));
    sdp_register_service_internal(NULL, service_record_item);
    
    // set one-shot timer
    timer_source_t heartbeat;
    heartbeat.process = &heartbeat_handler;
    run_loop_set_timer(&heartbeat, HEARTBEAT_PERIOD_MS);
    run_loop_add_timer(&heartbeat);
    
    log_info("SPP loopback demo...\n\r");

     // turn on!
    hci_power_control(HCI_POWER_ON);

    // go!
    run_loop_execute();    

    return 0;
}
#endif
