#ifndef STATES_H
#define STATES_H

#include "mbed.h"
#include "PID.h"
#include "pin_config.h"
#include "controller.h"
#include "R1370.h"
#include "wheelUnit.h"

//#define PI 3.14159

/*角度制御*/
//#define angleKP 5.5  //速さ
//#define angleKI 5.0  //揺れすぎたら大きく、動かな過ぎたら小さく
//#define angleKD 0.0000005  //ずらしたときに戻る力　がでかすぎたら小さく、小さすぎたら大きく

/*角度情報*/
#define front 0
#define right 90
#define back 180
#define left -90


class States
{
public:
    States();
    void tellAngle();
    void tellPad();
    void move();
private:
    /*非常停止*/
    DigitalOut emStop;
    
    /*モーター系*/
    WheelUnit omni;
    Serial serial;

    /*角度制御*/
    R1370 gyro;
    PID anglePID;
    float norm;
    float nowAngle;
    int idealAngle;
    float deviation;
    float turnPower;
    int state;

    /*コントローラ系*/
    Controller pad;
    float stickRad;
    float stickNorm;
    float X;
    float Y;
    int b[13],b2[13],b3[13];
};
#endif
