#ifndef PIN_CONFIG_H
#define PIN_CONFIG_H

#include "mbed.h"

#define PI 3.1415926535

/*MDC*/
#define MDTX PC_6
#define MDRX PC_7
#define MDBAUD 115200
#define MDcontrol D15

/*コントローラ*/
#define padTX PC_12
#define padRX PD_2
#define ADDRESS 208

/*R1370*/
#define GYROTX PB_6
#define GYRORX PA_10

/*非常停止*/
#define STOP PA_7

/*PID*/
const float KP = 10;        //速さ
const float KI = 5.0;        //揺れすぎたら大きく、動かな過ぎたら小さく
const float KD = 0.0000005;  //ずらしたときに戻る力　がでかすぎたら小さく、小さすぎたら大きく
const float minLimit = -1; //逆回転速度の最大値
const float maxLimit = 1;  //回転速度の最大値

/*モーター速度*/
const float SPEEDRATE = 0.7;
#endif
