/** A test program for pin_port
 * Takuo WATANABE
 * http://mbed.org/users/takuo/code/pin_port/
 */

#include "mbed.h"
#include "pin_port.h"
#include "pins.h"

#define LEN(a) (sizeof(a) / sizeof((a)[0]))

bool test_pin(PinName pin) {
    PortName port;
    int pos = pin_port(pin, &port);
    if (pin == port_pin(port, pos))
        return true;
    else {
        printf("bad: %d -> (%d, %d)\n", (int)pin, (int)port, pos);
        return false;
    }
}

void test_pins() {
    bool ok = true;
    for (int i = 0; i < LEN(pins); i++) {
        printf(".");
        if (!test_pin(pins[i]))
            ok = false;
    }
    printf("\n");
    if (ok)
        printf("OK\n");
}

int main() {
    PortName port;
    int pos = pin_port(LED1, &port);
    printf("LED1: port=%d, bit=%d\n", (int)port, pos);
    test_pins();
    return 0;
}
