/* A function for finding the port and bit position of a pin
 * Copyright 2015, Takuo Watanabe
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "mbed.h"
#include "pin_port.h"

int pin_port(PinName pin, PortName *port) {
#if defined(TARGET_LPC176X)
    int p = pin - LPC_GPIO0_BASE;
    *port = (PortName)(p >> PORT_SHIFT);
    return p & ((1 << PORT_SHIFT) - 1);
#elif defined(TARGET_LPC11UXX)
    *port = (PortName)((int)pin >> PORT_SHIFT);
    return ((1 << PORT_SHIFT) - 1) & (int)pin;
#elif defined(TARGET_KLXX)
    *port = (PortName)((int)pin >> PORT_SHIFT);
    return (((1 << PORT_SHIFT) - 1) & (int)pin) >> 2;
#elif defined(TARGET_KPSDK_MCUS)
    *port = (PortName)((int)pin >> GPIO_PORT_SHIFT);
    return ((1 << GPIO_PORT_SHIFT) - 1) & (int)pin;
#elif defined(TARGET_STM32F4)
    *port = (PortName)((int)pin >> 4);
    return 0xf & (int)pin;
#else
#error "Unsupported target"
#endif
}
