/** A demo program for STTS751 (I2C temperature sensor library)
 * Takuo WATANABE (wtakuo)
 */

#include "mbed.h"
#include "STTS751.h"

// I2C pins: p9 = sda, p10 = scl
STTS751 sensor(p9, p10);

// You can specify an I2C object instead.
// I2C i2c(p9, p10);
// STTS751 sensor(i2c);

// example using continuous conversion mode
int main() {
    // set the temperature resolution to 12bits
    sensor.setResolution(STTS751::RES_12);
    // set the conversion rate to 2/sec
    sensor.setConversionRate(5);
    while (true) {
        printf("temp: %.4f\n", (float)sensor);
        wait(1);
    }
}

/*
// example using standby mode
int main() {
    // set the device to standby mode
    sensor.setStandbyMode(true);
    // set the temperature resolution to 12bits
    sensor.setResolution(STTS751::RES_12);
    while (true) {
        // start a temperature measurement
        sensor.start();
        // waiting for finishing the measurement
        while (!sensor.ready())
            wait(0.01);
        printf("temp: %.4f\n", sensor.temp(true));
        wait(1);
    }
}
*/
