/* mbed Microcontroller Library
 * Copyright (c) 2019 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */
#include "mbed.h"
#include "platform/mbed_thread.h"
#include "rtos.h"

// Blinking rate in milliseconds
#define BLINKING_RATE_MS                    100
#define TH                                  0.5

const int sensArray[4] = {0, 1, 2, 3};
/*
const int sensArray[32] = {  0,  4,  2,  3,  0,  0,  1,  0, 
                            -2,  0,  0,  0, -1,  0,  0,  0, 
                            -4,  0,  0,  0,  0,  0,  0,  0, 
                            -3,  0,  0,  0,  0,  0,  0,  0};
*/
//DigitalOut led1(LED1);        // デジタル出力

//PwmOut led1(LED1);              // PWM出力

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

DigitalOut green(p24);
DigitalOut blue(p23);
DigitalOut red(p22);
DigitalOut yellow(p21);

//AnalogIn s0(p20);            // アナログ入力
//AnalogIn s1(p18);

DigitalIn s0(p20);            // アナログ入力
DigitalIn s1(p18);

Timeout sensor_tick;                // タイマ割込み


Serial pc(USBTX, USBRX); // tx, rx
//volatile int count = 0;
volatile float val0, val1;
volatile int flag = 0, sens_val;

Thread thread1;
Thread thread2;
Thread thread3;
Thread thread4;
Thread thread5;
Thread thread6;
/*void const *argument*/

void Led(DigitalOut *led){
    while(true){
        ThisThread::flags_wait_all(0x1);
        *led = !*led;
        //ThisThread::sleep_for(100);
    }
}
void check_sensor(){
    ::val0 = s0;
    ::val1 = s1;
}
void sensor(void const *argument){
    led4 = !led4;
    check_sensor();
    flag = 0;
    if(::val0 == 1) flag |= 0x2;
    if(::val1 == 1) flag |= 0x1;
    sens_val = sensArray[flag];
    switch(sens_val){
        case 0:
            thread3.flags_set(0x1);
            ThisThread::flags_clear(0x1);
            break;
        case 1:
            thread1.flags_set(0x1);
            thread4.flags_set(0x1);
            ThisThread::flags_clear(0x1);
            break;
        case 2:
            thread2.flags_set(0x1);
            thread5.flags_set(0x1);
            ThisThread::flags_clear(0x1);
            break;
        case 3:
            thread1.flags_set(0x1);
            thread2.flags_set(0x1);
            thread6.flags_set(0x1);
            ThisThread::flags_clear(0x1);
            break;
    }
}
int main()
{
    RtosTimer sensor_timer(sensor, osTimerPeriodic, (void *)0);     // タイマ割込み
    sensor_timer.start(50);
    
    //sensor_tick.attach_us(&sensor, 1000000);                         // これもタイマ割込み
    
    thread1.start(callback(Led, &led1));
    thread2.start(callback(Led, &led2));
    thread3.start(callback(Led, &green));
    thread4.start(callback(Led, &blue));
    thread5.start(callback(Led, &red));
    thread6.start(callback(Led, &yellow));

    while (true){
        led3 = !led3;
        ThisThread::sleep_for(10);
    }
}
