#ifndef WATCHDOG_H
#define WATCHDOG_H

#include "mbed.h"

/** Library for watchdog timer for LPC1549
 *
 */

class Watchdog {
public: 
    /**
    * Create a watchdog object
    *
    * @param msec Set the time-out period, specified in miliseconds (int)
    */
    Watchdog(int msec);
    
    /**
    * Feed the dog
    *
    * Call the function once in a loop
    */
    void feed();
    
    /**
    * Time-out flag
    *
    * true: watchdog reset,
    * false: external reset
    */
    bool timeOutFlag;
};

#endif