#if defined(TARGET_LPC1549)

#include "mbed.h"
#include "Watchdog.h"

Watchdog::Watchdog(int ms)
{
    timeOutFlag = (LPC_WWDT->MOD >> 2) & 1;
    LPC_SYSCON->SYSAHBCLKCTRL0 |= (1 << 22);
    LPC_SYSCON->PDRUNCFG &= ~(1 << 20);
    LPC_SYSCON->STARTERP0 |= 1;
    uint32_t clk = 503000 / 4;                          // LPC1549's watchdog oscillator is fixed to 503 kHz
    LPC_WWDT->TC = ((float)ms * (float)clk) / 1000;
    LPC_WWDT->MOD = 0x03;
    feed();
}

void Watchdog::feed()
{
    LPC_WWDT->FEED = 0xAA;
    LPC_WWDT->FEED = 0x55;
}

#endif