#ifndef MMA8652_H
#define MMA8652_H

#include "mbed.h"


// MMA8653 Slave Address
#define SLAVE_ADDR_7_BIT 0x1D

#define UINT14_MAX        16383

// MMA8653 internal register addresses
#define STATUS 0x00
#define OUT_X_MSB 0x01
#define OUT_X_LSB 0x02
#define OUT_Y_MSB 0x03
#define OUT_Y_LSB 0x04
#define OUT_Z_MSB 0x05
#define OUT_Z_LSB 0x06
#define SYSMOD 0x0B
#define INT_SOURCE 0x0C
#define WHO_AM_I 0x0D
#define XYZ_DATA_CFG 0x0E
#define PL_STATUS 0x10
#define PL_CFG 0x11
#define PL_COUNT 0x12
#define PL_BF_ZCOMP 0x13
#define PL_THS_REG 0x14
#define FF_MT_CFG 0x15
#define FF_MT_SRC 0x16
#define FF_MT_THS 0x17
#define FF_MT_COUNT 0x18
#define ASLP_COUNT 0x29
#define CTRL_REG1 0x2A
#define CTRL_REG2 0x2B
#define CTRL_REG3 0x2C
#define CTRL_REG4 0x2D
#define CTRL_REG5 0x2E
#define OFF_X 0x2F
#define OFF_Y 0x30
#define OFF_Z 0x31

#define MMA8652_STATUS 0x00
#define MMA8652_OUT_X_MSB 0x01
#define MMA8652_WHOAMI 0x0D
#define MMA8652_XYZ_DATA_CFG 0x0E
#define MMA8652_CTRL_REG1 0x2A
#define MMA8652_WHOAMI_VAL 0x4A

/** Library for the NXP MMA8653
 *
 */
class MMA8653
{
public:
    // Output buffer data format using full scale in register 0x0E[1-0]
    enum FS {
        PM2G = 0,
        PM4G,
        PM8G
    };

    // Data rate selection in register 0x02A[5-3]
    enum DR {
        DR800HZ = 0,
        DR400HZ,
        DR200HZ,
        DR100HZ,
        DR50HZ,
        DR12_5HZ,
        DR6_25HZ,
        DR1_56HZ
    };

    // Fast-read mode in register 0x02A[1]
    enum F_READ {
        Normal = 0,
        FastRead
    };

    /**
    * Create a MMA8653 object
    *
    * @param &i2c pointer of I2C object
    * @param dr dynamic range setting
    * @param fr fast read setting
    */
    MMA8653(I2C &i2c, FS fs = PM2G, DR dr= DR800HZ, F_READ fr = Normal);

    /**
     * Read 3-axis acceleration in floating point values (unit: G)
     *
     * @param *val array where acceleration data will be stored
     */
    void ReadXYZ(float *val);

    /**
     * Read 3-axis acceleration in signed 16-bit values (fast read should be off)
     *
     * @param *val array where acceleration data will be stored
     */
    void ReadXYZ_s16(short *val);

    /**
     * Read 3-axis acceleration in signed 8-bit values (fast read should be on)
     *
     * @param *val array where acceleration data will be stored
     */
    void ReadXYZ_s8(signed char *val);

private:
    void byteWrite(char reg, char *val, int len);
    void byteRead(char reg, char *val, int len);
    FS dynamicRange;
    bool fastReadFlag;
    I2C *_i2c;
};

#endif
