#include "MMA8653.h"

MMA8653::MMA8653(I2C &i2c, FS fs, DR dr, F_READ fr)
{
    _i2c = &i2c;
    char value[1];

    // Set the device STANDBY mode
    value[0] = 0x00;
    byteWrite(CTRL_REG1, value, 1);

    // Set the dynamic range
    dynamicRange = fs;
    value[0] = fs;
    byteWrite(XYZ_DATA_CFG, value, 1);

    // set the fast-read mode and set the device active
    fastReadFlag = (fr != Normal);
    value[0] = 0x01 | (fr << 1) | (dr << 3);
    byteWrite(CTRL_REG1, value, 1);
}

void MMA8653::byteWrite(char reg, char *val, int len)
{
    char buf[len+1];
    buf[0] = reg;
    for(int i = 0; i < len; i++)
        buf[i+1] = *(val + i);
    _i2c->write(SLAVE_ADDR_7_BIT<<1, buf, len+1, true);
}

void MMA8653::byteRead(char reg, char *val, int len)
{
    char buf[1];
    buf[0] = reg;
    _i2c->write(SLAVE_ADDR_7_BIT<<1, buf, 1, true);
    _i2c->read (SLAVE_ADDR_7_BIT<<1, val, len);
}

void MMA8653::ReadXYZ(float *val)
{
    if(!fastReadFlag) {
        short temp[3];
        ReadXYZ_s16(temp);
        for(int i = 0; i < 3; i++)
            val[i] = (float)temp[i] / 16384.0 / (float)(dynamicRange+ 1);
    } else {
        signed char temp[3];
        ReadXYZ_s8(temp);
        for(int i = 0; i < 3; i++)
            val[i] = (float)temp[i] / 64.0 / (float)(dynamicRange+ 1);
    }
}

void MMA8653::ReadXYZ_s16(short *val)
{
    if(!fastReadFlag){
        char value[6];
        byteRead(OUT_X_MSB, value, 6);
        for(int i = 0; i < 3; i++)
            val[i] = (value[i*2]<<8) | value[i*2+1];
    }else{
        for(int i = 0; i < 3; i++)
            val[i] = 0;
    }
}

void MMA8653::ReadXYZ_s8(signed char *val)
{
    if(fastReadFlag){
        char value[3];
        byteRead(OUT_X_MSB, value, 3);
        for(int i = 0; i < 3; i++)
            val[i] = value[i];
    }else{
        for(int i = 0; i < 3; i++)
            val[i] = 0;
    }
}