#include "DRV2667.h"

DRV2667::DRV2667(I2C &i2c, InputMux im, Gain gn, Timeout to)
{
    _i2c =  &i2c;
    wait_ms(1); // Wait for 1 ms for the DRV2667 device to power-up before attempting an I2C write
    init(im, gn, to);    
}

void DRV2667::i2cWriteByte(char reg, char value)
{
    char buff[2] = {reg, value};
    _i2c->write(SLAVE_ADDR_7_BIT<<1, buff, 2);
}

char DRV2667::i2cReadByte(char reg)
{
    char result;
    _i2c->write(SLAVE_ADDR_7_BIT<<1, &reg, 1, true);
    _i2c->read(SLAVE_ADDR_7_BIT<<1, &result, 1);

    return result;
}

void DRV2667::init(InputMux im, Gain gn, Timeout to)
{
    i2cWriteByte(0x02, 0x00);    // Exit low-power standby mode
    
    if(im != Digital || gn != GNx1){
        char temp = (i2cReadByte(0x01) | im) | gn;
        i2cWriteByte(0x01, temp);
    }
    if(to != TOx1 || im != Digital){
        char temp = (i2cReadByte(0x02) | to) | (im>>1);
        i2cWriteByte(0x02, temp);
    }
}

void DRV2667::reset(void)
{
    i2cWriteByte(0x02, 0x80);
}

void DRV2667::play()
{
    i2cWriteByte(0x02, i2cReadByte(0x02) | 1);
}

void DRV2667::stop()
{
    i2cWriteByte(0x02, i2cReadByte(0x02) & ~1);
}

bool DRV2667::isPlaying()
{
    return i2cReadByte(0x02) & 1;
}

void DRV2667::setWaveform(char* id, char setNum)
{
    for(int i = 0; i < setNum && i < 8; i++)
        i2cWriteByte(0x03 + i, id[i]);
    if(setNum < 8)
        i2cWriteByte(0x03 + setNum, 0);
}

//void DRV2667::loadFIFO(signed char data, char size)
//{
//
//}

void DRV2667::setWSP(char data[][5], char waveNum)
{
    i2cWriteByte(0xFF, 0x01);
    i2cWriteByte(0x00, waveNum / 5 * 5);
    for(int i = 0; i < waveNum / 5; i++){
        i2cWriteByte(0x01 + i * 5, 0x81);
        i2cWriteByte(0x02 + i * 5, 0x00 + i * 4);
        i2cWriteByte(0x03 + i * 5, 0x01);
        i2cWriteByte(0x04 + i * 5, 0x03 + i * 4);
        i2cWriteByte(0x05 + i * 5, data[i][4]);
    }
    
    i2cWriteByte(0xFF, 0x02);
    for(int i = 0; i < waveNum / 5; i++){
        i2cWriteByte(0x00 + i * 4, data[i][0]);
        i2cWriteByte(0x01 + i * 4, char(data[i][1] / 7.8125));
        i2cWriteByte(0x02 + i * 4, data[i][2]);
        i2cWriteByte(0x03 + i * 4, data[i][3]);
    }
    
    i2cWriteByte(0xFF, 0x00);
}

//void DRV2667::setDPR(void)
//{
//
//}