#ifndef _CRC8_H
#define _CRC8_H

#include "mbed.h"

// https://en.wikipedia.org/wiki/Cyclic_redundancy_check
//#define POLYNOMIAL_CRC8    (0xD5) // x^8 + x^7 + x^6 + x^4 + x^2 + x^1 + 1 (CRC-8)
//#define POLYNOMIAL_CRC8    (0x07) // x^8 + x^2 + x^1 + 1 (CRC-8-CCITT)
#define POLYNOMIAL_CRC8    (0x31) // x^8 + x^5 + x^4 + 1 (CRC-8-Dallas/Maxim)
//#define POLYNOMIAL_CRC8    (0x1D) // x^8 + x^4 + x^3 + x^2 + 1 (CRC-8-SAEJ1850)
//#define POLYNOMIAL_CRC8    (0x9B) // x^8 + x^7 + x^4 + x^3 + x^1 + 1 (CRC-8-WCDMA)

#define CHAR_BIT    8

/** Library for CRC-8
 *
 */

/**
 * Update CRC8 value
 *
 * @param *buff Storage location for data
 * @param size Size of data
 * @return Updated CRC8 value
 */
uint8_t crc8Update(const void *buff, size_t size);

#endif