/**
* @file
* ta7291p使用時のクラス
*/
#ifndef MBED_TA7291P_H
#define MBED_TA7291P_H

#include "mbed.h"

/** @code
 * #include "mbed.h"
 * #include "ta7291p.h"
 * 
 * TextLCD motor( p19, p20, p21);// DigitalOut, DijitalOut, PwmOut
 * 
 * int main() {
 *     motor.rotf( 0.4 );   //
 * }
 * @endcode
 */
 
class ta7291p{
protected:
    DigitalOut _do1, _do2;
    PwmOut _pwm;  
       
public:

    /** ta7291p使用時のピン設定
    * @param do1 set a pin as DigitalOut
    * @param do2 set a pin as DigitalOut
    * @param pwm set a pin as PwmOut
    */
    ta7291p ( PinName do1, PinName do2, PinName pwm);

    void rotf( float duty );        //前進する方向(PWM)
    void rotb( float duty );        //後進する方向(PWM)
    void rotbrake();    //
    void rotstop(); //   
};
#endif
