/**
@file main.cpp
 
@brief Program implementation
 
*/
#include "main.h"

void update()
{
    if (temperature <= -20.0) { // for temperatures -20 and below

        lcd.drawCircle(WIDTH/1.1,HEIGHT/1.2,5,0);  // x,y,radius,no fill
        //origin x,y,width,height,type
        lcd.drawRect(74,5,4,30,0);    // transparent, just outline
    }
    else if (temperature >-20.0 && temperature <= -10.0) {   // for temperatures between -20 and -10

        lcd.drawCircle(WIDTH/1.1,HEIGHT/1.2,5,1);  // x,y,radius,black fill
        //origin x,y,width,height,type
        lcd.drawRect(74,5,4,30,0);    // transparent, just outline
    }
    else if (temperature >-10.0 && temperature <= 0.0) { // for temperatures between -10 and 0

        lcd.drawCircle(WIDTH/1.1,HEIGHT/1.2,5,1);  // x,y,radius,black fill
        //origin x,y,width,height,type
        lcd.drawRect(74,5,4,30,0);    // transparent, just outline
        lcd.setPixel(75,34);
        lcd.setPixel(76,34);
        lcd.setPixel(77,34);
        lcd.setPixel(75,33);
        lcd.setPixel(76,33);
        lcd.setPixel(77,33);
    }
    else if (temperature >0.0 && temperature <= 5.0) {       // for temperatures between 0 and 5

        lcd.drawCircle(WIDTH/1.1,HEIGHT/1.2,5,1);  // x,y,radius,black fill
        //origin x,y,width,height,type
        lcd.drawRect(74,5,4,30,0);    // transparent, just outline
        lcd.setPixel(75,34);
        lcd.setPixel(76,34);
        lcd.setPixel(77,34);
        lcd.setPixel(75,33);
        lcd.setPixel(76,33);
        lcd.setPixel(77,33);
        lcd.setPixel(75,32);
        lcd.setPixel(76,32);
        lcd.setPixel(77,32);
        lcd.setPixel(75,31);
        lcd.setPixel(76,31);
        lcd.setPixel(77,31);
    }
    else if (temperature >5.0 && temperature <= 10.0) {      // for temperatures between 5 and 10

        lcd.drawCircle(WIDTH/1.1,HEIGHT/1.2,5,1);  // x,y,radius,black fill
        //origin x,y,width,height,type
        lcd.drawRect(74,5,4,30,0);    // transparent, just outline
        lcd.setPixel(75,34);
        lcd.setPixel(76,34);
        lcd.setPixel(77,34);
        lcd.setPixel(75,33);
        lcd.setPixel(76,33);
        lcd.setPixel(77,33);
        lcd.setPixel(75,32);
        lcd.setPixel(76,32);
        lcd.setPixel(77,32);
        lcd.setPixel(75,31);
        lcd.setPixel(76,31);
        lcd.setPixel(77,31);
        lcd.setPixel(75,30);
        lcd.setPixel(76,30);
        lcd.setPixel(77,30);
        lcd.setPixel(75,29);
        lcd.setPixel(76,29);
        lcd.setPixel(77,29);
    }
    else if (temperature >10.0 && temperature <= 15.0) {     // for temperatures between 10 and 15

        lcd.drawCircle(WIDTH/1.1,HEIGHT/1.2,5,1);  // x,y,radius,black fill
        //origin x,y,width,height,type
        lcd.drawRect(74,5,4,30,0);    //transparent, just outline
        lcd.setPixel(75,34);
        lcd.setPixel(76,34);
        lcd.setPixel(77,34);
        lcd.setPixel(75,33);
        lcd.setPixel(76,33);
        lcd.setPixel(77,33);
        lcd.setPixel(75,32);
        lcd.setPixel(76,32);
        lcd.setPixel(77,32);
        lcd.setPixel(75,31);
        lcd.setPixel(76,31);
        lcd.setPixel(77,31);
        lcd.setPixel(75,30);
        lcd.setPixel(76,30);
        lcd.setPixel(77,30);
        lcd.setPixel(75,29);
        lcd.setPixel(76,29);
        lcd.setPixel(77,29);
        lcd.setPixel(75,28);
        lcd.setPixel(76,28);
        lcd.setPixel(77,28);
        lcd.setPixel(75,27);
        lcd.setPixel(76,27);
        lcd.setPixel(77,27);
    }
    else if (temperature >15.0 && temperature <= 20.0) {     // for temperatures between 15 and 20

        lcd.drawCircle(WIDTH/1.1,HEIGHT/1.2,5,1);  // x,y,radius,black fill
        //origin x,y,width,height,type
        lcd.drawRect(74,5,4,30,0);    // transparent, just outline
        lcd.setPixel(75,34);
        lcd.setPixel(76,34);
        lcd.setPixel(77,34);
        lcd.setPixel(75,33);
        lcd.setPixel(76,33);
        lcd.setPixel(77,33);
        lcd.setPixel(75,32);
        lcd.setPixel(76,32);
        lcd.setPixel(77,32);
        lcd.setPixel(75,31);
        lcd.setPixel(76,31);
        lcd.setPixel(77,31);
        lcd.setPixel(75,30);
        lcd.setPixel(76,30);
        lcd.setPixel(77,30);
        lcd.setPixel(75,29);
        lcd.setPixel(76,29);
        lcd.setPixel(77,29);
        lcd.setPixel(75,28);
        lcd.setPixel(76,28);
        lcd.setPixel(77,28);
        lcd.setPixel(75,27);
        lcd.setPixel(76,27);
        lcd.setPixel(77,27);
        lcd.setPixel(75,26);
        lcd.setPixel(76,26);
        lcd.setPixel(77,26);
        lcd.setPixel(75,25);
        lcd.setPixel(76,25);
        lcd.setPixel(77,25);
    }
    else if (temperature >20.0 && temperature <= 25.0) {     // for temperatures between 20 and 25

        lcd.drawCircle(WIDTH/1.1,HEIGHT/1.2,5,1);  // x,y,radius,black fill
        //origin x,y,width,height,type
        lcd.drawRect(74,5,4,30,0);    // transparent, just outline
        lcd.setPixel(75,34);
        lcd.setPixel(76,34);
        lcd.setPixel(77,34);
        lcd.setPixel(75,33);
        lcd.setPixel(76,33);
        lcd.setPixel(77,33);
        lcd.setPixel(75,32);
        lcd.setPixel(76,32);
        lcd.setPixel(77,32);
        lcd.setPixel(75,31);
        lcd.setPixel(76,31);
        lcd.setPixel(77,31);
        lcd.setPixel(75,30);
        lcd.setPixel(76,30);
        lcd.setPixel(77,30);
        lcd.setPixel(75,29);
        lcd.setPixel(76,29);
        lcd.setPixel(77,29);
        lcd.setPixel(75,28);
        lcd.setPixel(76,28);
        lcd.setPixel(77,28);
        lcd.setPixel(75,27);
        lcd.setPixel(76,27);
        lcd.setPixel(77,27);
        lcd.setPixel(75,26);
        lcd.setPixel(76,26);
        lcd.setPixel(77,26);
        lcd.setPixel(75,25);
        lcd.setPixel(76,25);
        lcd.setPixel(77,25);
    }
    else if (temperature >25.0 && temperature <= 30.0) {     // for temperatures between 25 and 30

        lcd.drawCircle(WIDTH/1.1,HEIGHT/1.2,5,1);  // x,y,radius,black fill
        //origin x,y,width,height,type
        lcd.drawRect(74,5,4,30,0);    // transparent, just outline        
        lcd.setPixel(75,34);
        lcd.setPixel(76,34);
        lcd.setPixel(77,34);
        lcd.setPixel(75,33);
        lcd.setPixel(76,33);
        lcd.setPixel(77,33);
        lcd.setPixel(75,32);
        lcd.setPixel(76,32);
        lcd.setPixel(77,32);
        lcd.setPixel(75,31);
        lcd.setPixel(76,31);
        lcd.setPixel(77,31);
        lcd.setPixel(75,30);
        lcd.setPixel(76,30);
        lcd.setPixel(77,30);
        lcd.setPixel(75,29);
        lcd.setPixel(76,29);
        lcd.setPixel(77,29);
        lcd.setPixel(75,28);
        lcd.setPixel(76,28);
        lcd.setPixel(77,28);
        lcd.setPixel(75,27);
        lcd.setPixel(76,27);
        lcd.setPixel(77,27);
        lcd.setPixel(75,26);
        lcd.setPixel(76,26);
        lcd.setPixel(77,26);
        lcd.setPixel(75,25);
        lcd.setPixel(76,25);
        lcd.setPixel(77,25);
        lcd.setPixel(75,24);
        lcd.setPixel(76,24);
        lcd.setPixel(77,24);
        lcd.setPixel(75,23);
        lcd.setPixel(76,23);
        lcd.setPixel(77,23);
    }
    else if (temperature >30.0 && temperature <= 35.0) {     // for temperatures between 30 and 35

        lcd.drawCircle(WIDTH/1.1,HEIGHT/1.2,5,1);  // x,y,radius,black fill
        //origin x,y,width,height,type
        lcd.drawRect(74,5,4,30,0);    // transparent, just outline
        lcd.setPixel(75,34);
        lcd.setPixel(76,34);
        lcd.setPixel(77,34);
        lcd.setPixel(75,33);
        lcd.setPixel(76,33);
        lcd.setPixel(77,33);
        lcd.setPixel(75,32);
        lcd.setPixel(76,32);
        lcd.setPixel(77,32);
        lcd.setPixel(75,31);
        lcd.setPixel(76,31);
        lcd.setPixel(77,31);
        lcd.setPixel(75,30);
        lcd.setPixel(76,30);
        lcd.setPixel(77,30);
        lcd.setPixel(75,29);
        lcd.setPixel(76,29);
        lcd.setPixel(77,29);
        lcd.setPixel(75,28);
        lcd.setPixel(76,28);
        lcd.setPixel(77,28);
        lcd.setPixel(75,27);
        lcd.setPixel(76,27);
        lcd.setPixel(77,27);
        lcd.setPixel(75,26);
        lcd.setPixel(76,26);
        lcd.setPixel(77,26);
        lcd.setPixel(75,25);
        lcd.setPixel(76,25);
        lcd.setPixel(77,25);
        lcd.setPixel(75,24);
        lcd.setPixel(76,24);
        lcd.setPixel(77,24);
        lcd.setPixel(75,23);
        lcd.setPixel(76,23);
        lcd.setPixel(77,23);
        lcd.setPixel(75,22);
        lcd.setPixel(76,22);
        lcd.setPixel(77,22);
        lcd.setPixel(75,21);
        lcd.setPixel(76,21);
        lcd.setPixel(77,21);
    }
    else if (temperature >35.0 && temperature <= 40.0) {     // for temperatures between 35 and 40

        lcd.drawCircle(WIDTH/1.1,HEIGHT/1.2,5,1);  // x,y,radius,black fill
        //origin x,y,width,height,type
        lcd.drawRect(74,5,4,30,0);    // transparent, just outline
        lcd.setPixel(75,34);
        lcd.setPixel(76,34);
        lcd.setPixel(77,34);
        lcd.setPixel(75,33);
        lcd.setPixel(76,33);
        lcd.setPixel(77,33);
        lcd.setPixel(75,32);
        lcd.setPixel(76,32);
        lcd.setPixel(77,32);
        lcd.setPixel(75,31);
        lcd.setPixel(76,31);
        lcd.setPixel(77,31);
        lcd.setPixel(75,30);
        lcd.setPixel(76,30);
        lcd.setPixel(77,30);
        lcd.setPixel(75,29);
        lcd.setPixel(76,29);
        lcd.setPixel(77,29);
        lcd.setPixel(75,28);
        lcd.setPixel(76,28);
        lcd.setPixel(77,28);
        lcd.setPixel(75,27);
        lcd.setPixel(76,27);
        lcd.setPixel(77,27);
        lcd.setPixel(75,26);
        lcd.setPixel(76,26);
        lcd.setPixel(77,26);
        lcd.setPixel(75,25);
        lcd.setPixel(76,25);
        lcd.setPixel(77,25);
        lcd.setPixel(75,24);
        lcd.setPixel(76,24);
        lcd.setPixel(77,24);
        lcd.setPixel(75,23);
        lcd.setPixel(76,23);
        lcd.setPixel(77,23);
        lcd.setPixel(75,22);
        lcd.setPixel(76,22);
        lcd.setPixel(77,22);
        lcd.setPixel(75,21);
        lcd.setPixel(76,21);
        lcd.setPixel(77,21);
        lcd.setPixel(75,20);
        lcd.setPixel(76,20);
        lcd.setPixel(77,20);
        lcd.setPixel(75,19);
        lcd.setPixel(76,19);
        lcd.setPixel(77,19);
    }
    else if (temperature >40.0 && temperature <= 50.0) {     // for temperatures between 40 and 50

        lcd.drawCircle(WIDTH/1.1,HEIGHT/1.2,5,1);  // x,y,radius,black fill
        //origin x,y,width,height,type
        lcd.drawRect(74,5,4,30,0);    // transparent, just outline
        lcd.setPixel(75,34);
        lcd.setPixel(76,34);
        lcd.setPixel(77,34);
        lcd.setPixel(75,33);
        lcd.setPixel(76,33);
        lcd.setPixel(77,33);
        lcd.setPixel(75,32);
        lcd.setPixel(76,32);
        lcd.setPixel(77,32);
        lcd.setPixel(75,31);
        lcd.setPixel(76,31);
        lcd.setPixel(77,31);
        lcd.setPixel(75,30);
        lcd.setPixel(76,30);
        lcd.setPixel(77,30);
        lcd.setPixel(75,29);
        lcd.setPixel(76,29);
        lcd.setPixel(77,29);
        lcd.setPixel(75,28);
        lcd.setPixel(76,28);
        lcd.setPixel(77,28);
        lcd.setPixel(75,27);
        lcd.setPixel(76,27);
        lcd.setPixel(77,27);
        lcd.setPixel(75,26);
        lcd.setPixel(76,26);
        lcd.setPixel(77,26);
        lcd.setPixel(75,25);
        lcd.setPixel(76,25);
        lcd.setPixel(77,25);
        lcd.setPixel(75,24);
        lcd.setPixel(76,24);
        lcd.setPixel(77,24);
        lcd.setPixel(75,23);
        lcd.setPixel(76,23);
        lcd.setPixel(77,23);
        lcd.setPixel(75,22);
        lcd.setPixel(76,22);
        lcd.setPixel(77,22);
        lcd.setPixel(75,21);
        lcd.setPixel(76,21);
        lcd.setPixel(77,21);
        lcd.setPixel(75,20);
        lcd.setPixel(76,20);
        lcd.setPixel(77,20);
        lcd.setPixel(75,19);
        lcd.setPixel(76,19);
        lcd.setPixel(77,19);
        lcd.setPixel(75,18);
        lcd.setPixel(76,18);
        lcd.setPixel(77,18);
        lcd.setPixel(75,17);
        lcd.setPixel(76,17);
        lcd.setPixel(77,17);
    }
    else if (temperature >50.0 && temperature <= 65.0) {     // for temperatures between 50 and 65
    
        lcd.drawCircle(WIDTH/1.1,HEIGHT/1.2,5,1);  // x,y,radius,black fill
        //origin x,y,width,height,type
        lcd.drawRect(74,5,4,30,0);    // transparent, just outline
        lcd.setPixel(75,34);
        lcd.setPixel(76,34);
        lcd.setPixel(77,34);
        lcd.setPixel(75,33);
        lcd.setPixel(76,33);
        lcd.setPixel(77,33);
        lcd.setPixel(75,32);
        lcd.setPixel(76,32);
        lcd.setPixel(77,32);
        lcd.setPixel(75,31);
        lcd.setPixel(76,31);
        lcd.setPixel(77,31);
        lcd.setPixel(75,30);
        lcd.setPixel(76,30);
        lcd.setPixel(77,30);
        lcd.setPixel(75,29);
        lcd.setPixel(76,29);
        lcd.setPixel(77,29);
        lcd.setPixel(75,28);
        lcd.setPixel(76,28);
        lcd.setPixel(77,28);
        lcd.setPixel(75,27);
        lcd.setPixel(76,27);
        lcd.setPixel(77,27);
        lcd.setPixel(75,26);
        lcd.setPixel(76,26);
        lcd.setPixel(77,26);
        lcd.setPixel(75,25);
        lcd.setPixel(76,25);
        lcd.setPixel(77,25);
        lcd.setPixel(75,24);
        lcd.setPixel(76,24);
        lcd.setPixel(77,24);
        lcd.setPixel(75,23);
        lcd.setPixel(76,23);
        lcd.setPixel(77,23);
        lcd.setPixel(75,22);
        lcd.setPixel(76,22);
        lcd.setPixel(77,22);
        lcd.setPixel(75,21);
        lcd.setPixel(76,21);
        lcd.setPixel(77,21);
        lcd.setPixel(75,20);
        lcd.setPixel(76,20);
        lcd.setPixel(77,20);
        lcd.setPixel(75,19);
        lcd.setPixel(76,19);
        lcd.setPixel(77,19);
        lcd.setPixel(75,18);
        lcd.setPixel(76,18);
        lcd.setPixel(77,18);
        lcd.setPixel(75,17);
        lcd.setPixel(76,17);
        lcd.setPixel(77,17);
        lcd.setPixel(75,16);
        lcd.setPixel(76,16);
        lcd.setPixel(77,16);
        lcd.setPixel(75,15);
        lcd.setPixel(76,15);
        lcd.setPixel(77,15);
    }
}

void print()
{
    if(graphTempFlag == 0 && graphPresFlag == 0 && unitsFlag == 0) {    //no button is pressed or button 4 is pressed

        char buffer2[14];  // each character is 6 pixels wide, screen is 84 pixels (84/6 = 14)
        // so can display a string of a maximum 14 characters in length
        // or create formatted strings - ensure they aren't more than 14 characters long
        float length = sprintf(buffer2,"T= %.2f C",temperature); // print formatted data to buffer
        // it is important the format specifier ensures the length will fit in the buffer
        if (length <= 14)  // if string will fit on display
            lcd.printString(buffer2,0,1);         // display on screen

        length = sprintf(buffer2,"P= %.2fmb",pressure);     //print formatted data to buffer
        if (length <= 14){      // if string will fit on display
        lcd.printString(buffer2,0,2);   // display on screen
        lcd.printString(bufferT,0,4);   // display on screen
        lcd.printString(bufferD,0,5);   // display on screen
        }
        lcd.drawLine(0,30,48,30,2);    
        lcd.drawLine(48,30,48,48,2);
        
        update();   //update thermometer
        
        //set 0 degrees indicator
        lcd.setPixel(72,33);
        lcd.setPixel(71,33);
        lcd.setPixel(70,33);
        lcd.setPixel(69,33);
        lcd.printChar('0',58,34);

        //set 65 degrees indicator
        lcd.setPixel(72,5);
        lcd.setPixel(71,5);
        lcd.setPixel(70,5);
        lcd.setPixel(69,5);
        lcd.printChar('5',62,6);
        lcd.printChar('6',56,6);
        
            
            if(temperature >15 && temperature <= 35){ //good weather
                    //draw a sun on screen
                    lcd.drawCircle(WIDTH/1.5,HEIGHT/1.2,2,1);  // x,y,radius,black fill
                    lcd.drawLine(53,40,59,40,1);
                    lcd.drawLine(56,37,56,43,1);
                    lcd.drawLine(53,37,59,43,1);
                    lcd.drawLine(59,37,53,43,1);
                    }
                else if (temperature <= 15) {   //cold weather
                    //draw a rainy cloud on screen
                    lcd.setPixel(57,37);
                    lcd.setPixel(56,37);
                    lcd.setPixel(56,36);
                    lcd.setPixel(55,37);       
                    lcd.setPixel(58,42);
                    lcd.setPixel(58,38);
                    lcd.setPixel(58,37);
                    lcd.setPixel(54,44);
                    lcd.setPixel(59,44);
                    lcd.setPixel(60,47);
                    lcd.setPixel(56,45);
                    lcd.setPixel(61,45);
                    lcd.drawCircle(WIDTH/1.5,HEIGHT/1.2,2,1);  // x,y,radius,black fill
                    lcd.drawCircle(WIDTH/1.4,HEIGHT/1.2,2,1);  // x,y,radius,black fill
                    }
                else {  //hot weather  
                    //draw a bigger sun on screen    
                    lcd.drawCircle(WIDTH/1.5,HEIGHT/1.2,2,1);  // x,y,radius,black fill
                    lcd.drawLine(52,40,60,40,1);
                    lcd.drawLine(56,36,56,44,1);
                    lcd.drawLine(53,37,59,43,1);
                    lcd.drawLine(59,37,53,43,1);
                    }
            
        
    } else if(graphTempFlag == 0 && graphPresFlag == 0 && unitsFlag) {  //button3 pressed

        char buffer2[14];  // each character is 6 pixels wide, screen is 84 pixels (84/6 = 14)
        // so can display a string of a maximum 14 characters in length
        // or create formatted strings - ensure they aren't more than 14 characters long
        float length = sprintf(buffer2,"T= %.2f K",temperature+273.15); // print formatted data to buffer
        // it is important the format specifier ensures the length will fit in the buffer
        if (length <= 14){  // if string will fit on display
            lcd.printString(buffer2,0,1);         // display on screen
            }
        length = sprintf(buffer2,"P= %.2f b",pressure/1000);    // print formatted data to buffer
        if (length <= 14){  // if string will fit on display
            
        lcd.printString(buffer2,0,2);   // display on screen
        lcd.printString(bufferT,0,4);   // display on screen
        lcd.printString(bufferD,0,5);   // display on screen
        }
        lcd.drawLine(0,30,48,30,2);
        lcd.drawLine(48,30,48,48,2);
    
        update();   //update thermometer

        //set 273.15K indicator
        lcd.setPixel(72,33);
        lcd.setPixel(71,33);
        lcd.setPixel(70,33);
        lcd.setPixel(69,33);
        lcd.printString("273",46,34);

        //set 338.15K indicator
        lcd.setPixel(72,5);
        lcd.setPixel(71,5);
        lcd.setPixel(70,5);
        lcd.setPixel(69,5);
        lcd.printString("338",50,6);

    } else if(graphTempFlag && graphPresFlag == 0 && unitsFlag == 0) {  //if button is pressed

        char buffer3[14];  // each character is 6 pixels wide, screen is 84 pixels (84/6 = 14)
        // so can display a string of a maximum 14 characters in length
        // or create formatted strings - ensure they aren't more than 14 characters long
        float tave; //store average temperature
        float t_sum=0;  //store sum of temperatures
        float t_count=0;    //store position in the array

        for (int ind = 0; ind<84; ind++) {
            if (array[ind] > 0) {
                t_sum = t_sum + array[ind]*65;
                t_count++;
            }
        }
        tave = t_sum/t_count;
        float length3 = sprintf(buffer3,"Tave = %.2f C",tave); // print formatted data to buffer
        // it is important the format specifier ensures the length will fit in the buffer
        if (length3 <= 14){  // if string will fit on display
            lcd.printString(buffer3,0,1);         // display on screen
            }
            if(temperature >15 && temperature <= 35){
                lcd.printString(" Good Weather",0,2);  //print string
                }
            else if (temperature <= 15)
                lcd.printString(" Cold Weather",0,2);  //print string
            else {
                lcd.printString("  Hot Weather",0,2);  //print string
                }

    } else if(graphTempFlag == 0 && graphPresFlag && unitsFlag == 0) {  //button2 pressed

        char buffer4[14];  // each character is 6 pixels wide, screen is 84 pixels (84/6 = 14)
        // so can display a string of a maximum 14 characters in length
        // or create formatted strings - ensure they aren't more than 14 characters long
        float pave; //store average pressure
        float p_sum=0;  //store sum of presuures
        float p_count=0;    //store position in the array2

        for (int ind = 0; ind<84; ind++) {
            if (array2[ind] > 0) {
                p_sum = p_sum + array2[ind]*1100;
                p_count++;
            }
        }
        pave = p_sum/p_count;
        float length4 = sprintf(buffer4,"Pave=%.2fmb",pave); // print formatted data to buffer
        // it is important the format specifier ensures the length will fit in the buffer
        if (length4 <= 14) { // if string will fit on display
            lcd.printString(buffer4,0,1);         // display on screen
            }
            if(pressure >999){
                lcd.printString("Clear Weather",0,2);  //print string
                }
            else if(pressure <= 999 && pressure >700){
                lcd.printString(" Windy/Cloudy",0,2);  //print string
                }
            else 
                lcd.printString("Rainy Weather",0,2);  //print string
    }        
}

//ISR
void timerExpiredReading()
{
    readingFlag = 1;  //set flag to 1
}
void timerExpiredTime()
{
    timerFlag = 1;  //set flag to 1
}
void timeExpiredFiles()
{
    timerFilesFlag = 1; //set flag to 1
}
void buttonTempPressed()
{
    graphTempFlag = !graphTempFlag; //toggle flag
}
void buttonPresPressed()
{
    graphPresFlag = !graphPresFlag; //toggle flag
}
void buttonUnitsPressed()
{
    unitsFlag = !unitsFlag; //toggle flag
}
void timerExpiredClear()
{
    clearFlag = 1;  //set flag to 1
}
int main()
{
    pc.baud(9600); //set baud rate
    // first need to initialise display
    lcd.init();
    // initiliase barometer
    bmp180.init();
    serial.attach(&serialISR); // attach serial ISR
    Measurement measurement;  // measurement structure declared in BMP180 class
    PHY_PowerDown();    //power down the Ethernet
    timerClearScreen.attach(&timerExpiredClear,0.2); //call ISR every 0.2 sec
    timerReading.attach(&timerExpiredReading,10.0);  //call ISR every 10 sec
    timerFiles.attach(&timeExpiredFiles,10.0);  //write data to file every 10 sec
    //set_time(1431012720); // initialise time to 1st January 1970
    timer.attach(&timerExpiredTime,1.0);    //attach timer

    green = 0;  //set LED initially to 0
    red = 0;  //set LED initially to 0
    lcd.setBrightness(ain/3.2); //set brightness according to the pot voltage
    
    button.rise(&buttonTempPressed);    //change the button state
    button2.rise(&buttonPresPressed);    //change the button state
    button3.rise(&buttonUnitsPressed);    //change the button state

    lcd.clear();    //clear display
    lcd.refresh();  //refresh display
    buzzer.beep(1000,0.5);  //beep the buzzer 
    lcd.printString("WeatherStation",1,1);  //print string
    lcd.printString("      by",1,2);    //print string
    lcd.printString(" Panagiotis",1,3); //print string
    lcd.printString(" Rodosthenous",1,4);   //print string
    lcd.printString("* * * * * * *",1,0);   //print string
    lcd.printString("* * * * * * *",1,5);   //print string
    //Display to lcd the above details
    wait(3);    //3 sec delay
    lcd.clear();    //clear display
    lcd.refresh();  //refresh display
    buzzer.beep(1000,0.5);  //beep the buzzer 
    lcd.printString("  University",1,1);  //print string
    lcd.printString("      of",1,2);    //print string
    lcd.printString("     Leeds",1,3); //print string
    lcd.drawCircle(WIDTH/2,HEIGHT/1.2,4,1);  // x,y,radius,black fill
    //draw sun
    lcd.setPixel(46,36);
    lcd.setPixel(47,35);
    lcd.setPixel(37,45);
    lcd.setPixel(38,44);
    lcd.setPixel(46,44);
    lcd.setPixel(47,45);
    lcd.setPixel(37,35);
    lcd.setPixel(38,36);
    //origin x,y,width,height,type
    lcd.drawRect(1,1,81,45,0);    // transparent, just outline
    lcd.drawLine(35,40,49,40,1);
    lcd.drawLine(42,33,42,47,1);
    lcd.inverseMode();  //inverse mode ON
    wait(3);    //3 sec delay
    lcd.clear();    //clear display
    lcd.refresh();  //refresh display
    lcd.normalMode();   //normal mode ON
    
    buzzer.beep(1000,0.5);  //beep the buzzer 

    while(1) {
        
        if(clearFlag){
            clearFlag = 0;  //set flag to 0
            lcd.clear();    //clear display
            lcd.refresh();  //refresh display
            }
        if(readingFlag) {
            readingFlag = 0;
            // read values (T in Celsius and P in mb) and print over serial port
            measurement = bmp180.readValues();
            temperature = measurement.temperature;
            pressure = measurement.pressure;
            serial.printf("T = %.2f C\nP = %.2f mb\n",measurement.temperature,measurement.pressure);    //print measurements to serial

            if(i == 84) {
                for(int n = 0; n <= 82; n++) {
                    array[n] = array[n+1];
                }      
                for(int z = 0; z <= 82; z++) {
                    array2[z] = array2[z+1];
                }
                i = 83;
                }
            array[i] = temperature/65;  //store temperature to array
            array2[i] = pressure/1100;  //store pressure to array
            i++;
        }
        if(timerFlag) {
            timerFlag = 0;  //set flag to 0
            time_t seconds = time(NULL); // get current time
            // format time into a string (time and date)
            strftime(bufferT, 14 , "%T", localtime(&seconds));
            strftime(bufferD, 14 , "%D", localtime(&seconds));
            // print over serial
            serial.printf("Time = %s\n",bufferT);    //print to pc
        }
        if (setTimeFlag) { // if updated time has been sent
            setTimeFlag = 0; // clear flag
            setTime(); // update time
        }
        if(graphTempFlag) {
            // values must be in range 0.0 - 1.0
            lcd.plotArray(array);
            lcd.normalMode();      // normal colour mode back
            button2.rise(NULL); //disable interrupt
        } else
            button2.rise(&buttonPresPressed); //enable interrupt

        if(graphPresFlag) {
            // values must be in range 0.0 - 1.0
            lcd.plotArray(array2);
            lcd.normalMode();      // normal colour mode back
            button.rise(NULL); //disable interrupt
        } else
            button.rise(&buttonTempPressed); //enable interrupt

        if(temperature >= 35) {
            buzzer.beep(1000,0.5);  //beep the buzzer if the temp is higher than a predetermined value
        }
        if(temperature >= 22 && temperature < 30) {
            green = 1;  //light the LED if the temp is in the specific range
        } else
            green = 0;  //turn off the LED

        if(button4 == 1) {
            graphTempFlag = 0;  //set flag to 0
            graphPresFlag = 0;  //set flag to 0
            unitsFlag = 0;  //set flag to 0
        }
        if(switch_logging == 1) {   //if switch is high

            if(timerFilesFlag) {
                timerFilesFlag = 0; //set flag to 0
                writeDataToFile(temperature,bufferT,pressure);  //call function to write data to file
                red = 1;    //light the red LED
            }
        } else red = 0; //turn off the LED

        // Set Brightness
        lcd.setBrightness(ain/3.3); //set brightness according to the pot voltage
        
        print();    //call print function
        
        Sleep();    //put the processor on sleep mode
    }
}
void setTime()
{
// print time for debugging
    serial.printf("set_time - %s",rxString);
// atoi() converts a string to an integer
    int time = atoi(rxString);
// update the time
    set_time(time);
}
void serialISR()
{
// when a serial interrupt occurs, read rx string into buffer
    serial.gets(rxString,16);
// set flag
    setTimeFlag = 1;
}
void writeDataToFile(float tempereture,char* time,float pressure)
{
    leds = 15; // turn on LEDs for feedback
    FILE *fp = fopen("/local/log.csv", "a"); // open 'log.csv' for appending
// if the file doesn't exist it is created, if it exists, data is appended to the end
    fprintf(fp,"%s , %.2f, %.2f\n",time,tempereture,pressure); // print string to file
    fclose(fp); // close file
    leds = 0; // turn off LEDs to signify file access has finished
}