// CW04 
// Oubun kaidoku
#include "mbed.h"
#include "TextLCD0420.h"

#define ON 1
#define OFF 0
#define XON 0
#define XOFF 1
#define XHI 0
#define XLOW 1
#define HI 1
#define LOW 0
#define OUBUN 1
#define WABUN 0

DigitalOut mled1(LED1);
DigitalOut mled2(LED2);
DigitalOut mled3(LED3);
DigitalOut mled4(LED4);
DigitalIn CW(p5);
DigitalIn SP_SELECT(p6);
DigitalIn GENGO_MODE(p7);
DigitalIn GENGO_SELECT(p8);

TextLCD lcd(p24, p25, p26, p27, p28, p29, p30,20,4); // rs, rw, e, d0, d1, d2, d3

int min_ms,max_ms;

void set_speed(){
  if(SP_SELECT==HI){
    min_ms=30;
    max_ms=90;
    lcd.locate(5,0);
    lcd.printf("H");
  }
  else if(SP_SELECT==LOW){
    min_ms=70;
    max_ms=210;
    lcd.locate(5,0);
    lcd.printf("L");
  }
}  

int main() {      
  
  int i,j,k;
  int code[20];
  int scount;
  char mj[115];
  int cw_sum,tan_sum,tanten;
  
  for(i=0;i<115;i++){
    mj[i]=' ';
  }
  mj[5]='A';mj[16]='B';mj[20]='C';mj[8]='D';mj[1]='E';
  mj[19]='F';mj[10]='G';mj[15]='H';mj[3]='I';mj[29]='J';
  mj[12]='K';mj[17]='L';mj[6]='M';mj[4]='N';mj[14]='O';
  mj[21]='P';mj[26]='Q';mj[9]='R';mj[7]='S';mj[2]='T';
  mj[11]='U';mj[23]='V';mj[13]='W';mj[24]='X';mj[28]='Y';
  mj[18]='Z';
  mj[61]='1';mj[59]='2';mj[55]='3';mj[47]='4';mj[31]='5';
  mj[32]='6';mj[34]='7';mj[38]='8';mj[46]='9';mj[62]='0';
  mj[105]='.';mj[114]=',';mj[75]='?';mj[48]='=';mj[96]='-';
  mj[70]=':';mj[93]='\'';mj[44]='(';mj[108]=')';mj[41]='+';
  mj[81]='"';    

  lcd.cls();
  lcd.printf("*CW04");
  set_speed();
  lcd.printf("\n");
  
  for(i=0;i<6;i++){
    code[i]=0;
  }

  i=0;
  tan_sum=0;
  tanten=80;
  j=0;
  tan_sum=0;
  while(1){
        while(CW==XLOW){
        }
        
        scount=0;  
        mled1=ON;
        while(CW==XHI){
          wait_ms(1);
          scount++;
        }
        mled1=OFF;
        
        if(min_ms < scount && scount < max_ms){ 
          //lcd.printf(".");
          code[k]=1;
          k++;
          tan_sum=tan_sum+scount;
          j++;
        }

        else if ( scount > tanten*2.0){
          //lcd.printf("_");
          code[k]=2;
          k++;
          tan_sum=tan_sum+scount/3;
          j++;
        }
                        
        scount=0;
        while(CW==XLOW){
          wait_ms(1);
          scount++;
          if(scount > tanten*10){
            break;
          }
        }
        
        if(k>=6){
          k=0;
          lcd.printf("*");
          for(i=0;i<6;i++){
            code[i]=0;
          }
        }
        
        if(scount > tanten*2.0){      
          cw_sum=0;
          for(i=0;i<6;i++){
              cw_sum=cw_sum+code[i]*int(pow(2.0,i));
          }
          lcd.printf("%c",mj[cw_sum]);
          k=0;
          for(i=0;i<6;i++){
            code[i]=0;
          }
        }//if
        
        if(scount > tanten*7){
          lcd.printf(" ");
        }
        
        if(j==10){
          tanten=tan_sum/10;
          tan_sum=0;
          j=0;
        }
  }//while 1
}//main
