// mbed RMCS09 2ressha 2point CTS
// mbed RailModelContorolSystem

#include "mbed.h"
#include "TextLCD0420.h"

#define ON 1
#define OFF 0
#define XON 0
#define XOFF 1

DigitalOut mled1(LED1);
DigitalOut mled2(LED2);
DigitalOut mled3(LED3);
DigitalOut mled4(LED4);
AnalogIn vr1_adc(p15);
AnalogIn vr2_adc(p16);
DigitalIn sens1(p17);
DigitalIn sens2(p18);
DigitalIn sens3(p19);
PwmOut r1_pwm(p22);
PwmOut r2_pwm(p23);
DigitalOut po10(p5);
DigitalOut po11(p6);
DigitalOut po20(p7);
DigitalOut po21(p8);

TextLCD lcd(p24, p25, p26, p27, p28, p29, p30,20,4); // rs, rw, e, d0, d1, d2, d3

float pduty,pduty_slow;
int point_sts;
int t_count,count;
int ressha,r_flag;

void disp_status(){
  lcd.locate(0,0);
  lcd.printf("* mbed RMCS101 T:%3d *",t_count);
  lcd.locate(0,1);
  lcd.printf("N:%2.0f%% C:%1d r:%1d   ",pduty*100,count,r_flag);
}

void notch(float duty){
  r1_pwm.write(duty);
  r2_pwm.write(0);
}

void r_notch(float duty){
  r1_pwm.write(0);
  r2_pwm.write(duty);
}

void slow_start(){
  lcd.locate(0,2);
  lcd.printf("Notch Up     ");
  pduty=vr1_adc.read();
  pduty_slow=pduty*0.95;
  disp_status();            
  notch(pduty_slow);
  wait(1.0);
  notch(pduty);
  wait(1.0);
}

void r_slow_start(){
  lcd.locate(0,2);
  lcd.printf("rNotch Up    ");
  pduty=vr2_adc.read();
  pduty_slow=pduty*0.95;
  disp_status();            
  r_notch(pduty_slow);
  wait(1.0);
  r_notch(pduty);
  wait(1.0);
}

void point1(int x){
  if(x==0){
    po10=ON;
    po11=OFF;
    wait(0.2);
    po10=OFF;
    po11=OFF;
  }
  else if(x==1){
    po10=OFF;
    po11=ON;
    wait(0.2);
    po10=OFF;
    po11=OFF;
  }
}

void point2(int x){
  if(x==0){
    po20=ON;
    po21=OFF;
    wait(0.2);
    po20=OFF;
    po21=OFF;
  }
  else if(x==1){
    po20=OFF;
    po21=ON;
    wait(0.2);
    po20=OFF;
    po21=OFF;
  }
}

int main() {      
  int init_sts;
  r1_pwm.pulsewidth(0.000001);//1us=0.000001
  r1_pwm.period(0.00001);//1ms=0.001s
  r2_pwm.pulsewidth(0.000001);//1us=0.000001
  r2_pwm.period(0.00001);//1ms=0.001s
  
  lcd.cls();
  lcd.locate(0,0);
  lcd.printf("Set Train on rail!!");
  lcd.locate(0,1);
  lcd.printf("==>Sns1:Hi,Sns2:Low");
  lcd.locate(0,2);
  lcd.printf("==>OK? Main pwr on!");
 
  count=0;
  t_count=0;
  notch(0);
  
  init_sts=1;
  ressha=0;  
  while(init_sts==1){
    if(sens1==XON && sens2==XOFF){
      lcd.cls();
      lcd.locate(0,0);
      lcd.printf("** mbed RMCS **");
      lcd.locate(0,1);
      lcd.printf("System start ...");
      wait(1.0);
      point_sts=1; 
      point1(point_sts);
      point2(point_sts);
      point_sts=1-point_sts;
      init_sts=0;
    }
  }
  
  ressha=0; 
  while(1){
      slow_start();
      while(ressha==0){
        pduty=vr1_adc.read();
        pduty_slow=pduty*0.95;       
        notch(pduty);
        disp_status();              
        if(sens1==XON){
          if(count<=2){
            while(sens1==XON){
            }
          }
          count++;
          t_count++;
          r_flag=0;
          disp_status();
        }
        
        if(sens3==XON){
         while(sens3==XON){
         }
         r_flag=1;
        }
        
        if(count <= 2){
            disp_status();
            lcd.locate(0,2);
            lcd.printf("No:E001        ");
            notch(pduty);
        }
        else if(count==3 && r_flag==1){
          pduty=pduty_slow;
          notch(pduty);
          disp_status();
          lcd.locate(0,2);
          lcd.printf("Notch OFF        ");
        }
        else if(count==4){
          notch(0);
          lcd.locate(0,2);
          lcd.printf("Break!!      ");
          wait(1.0);
          point1(point_sts);
          point2(point_sts);
          point_sts=1-point_sts;
          count=0;
          ressha=1;
          wait(2.0);
       }
     }//while
     
      r_slow_start();
      while(ressha==1){
        pduty=vr2_adc.read();
        pduty_slow=pduty*0.95;       
        r_notch(pduty);
        disp_status();       
        if(sens2==XON){
          if(count<=2){
            while(sens2==XON){
            }
          }
          count++;
          t_count++;
          r_flag=0;
          disp_status();
        }
        
        if(sens3==XON){
         while(sens3==XON){
         }
         r_flag=1;
        }
        
        if(count <= 2){
            disp_status();
            lcd.locate(0,2);
            lcd.printf("No:E002        ");
            r_notch(pduty);
        }
        else if(count==3 && r_flag==1){
          pduty=pduty_slow;
          r_notch(pduty);
          disp_status();
          lcd.locate(0,2);
          lcd.printf("Notch OFF        ");
        }
        else if(count==4){
          r_notch(0);
          lcd.locate(0,2);
          lcd.printf("Break!!      ");
          wait(1.0);
          point1(point_sts);
          point2(point_sts);
          point_sts=1-point_sts;
          count=0;
          ressha=0;
          wait(2.0);
       }
     }//while     
     
  }//while    
}//main
