// mRMCS07 sens1 hanten
// mbed RailModelContorolSystem

#include "mbed.h"
#include "TextLCD0420.h"

#define ON 1
#define OFF 0
#define XON 0
#define XOFF 1

DigitalOut mled1(LED1);
DigitalOut mled2(LED2);
DigitalOut mled3(LED3);
DigitalOut mled4(LED4);
AnalogIn vr1_adc(p15);
AnalogIn vr2_adc(p16);
DigitalIn sens1(p17);
DigitalIn sens2(p18);
DigitalIn sens3(p19);
PwmOut r1_pwm(p22);
PwmOut r2_pwm(p23);
DigitalOut po10(p5);
DigitalOut po11(p6);
DigitalOut po20(p7);
DigitalOut po21(p8);

TextLCD lcd(p24, p25, p26, p27, p28, p29, p30,20,4); // rs, rw, e, d0, d1, d2, d3

float pduty,pduty_slow;

void notch(float duty){
  r1_pwm.write(duty);
  r2_pwm.write(0);
}

void r_notch(float duty){
  r1_pwm.write(0);
  r2_pwm.write(duty);
}

int main() {      
  int i,count,ressha;
  float pduty;
  r1_pwm.pulsewidth(0.000001);//1us=0.000001
  r1_pwm.period(0.00001);//1ms=0.001s
  r2_pwm.pulsewidth(0.000001);//1us=0.000001
  r2_pwm.period(0.00001);//1ms=0.001s

  count=0;
  lcd.cls();
  lcd.locate(0,0);
  lcd.printf("** mbed RMCS07 **");
  
  while(1){
    pduty=vr1_adc.read();
    notch(pduty);   
    wait(1.0);
    while(sens1==XOFF){
      pduty=vr1_adc.read();
      notch(pduty);
      lcd.locate(0,1);
      lcd.printf("d:%3.0f%%",pduty*100);
      lcd.locate(0,2);
      lcd.printf("  notch ON!");
    }
    notch(0);
    lcd.locate(0,1);
    lcd.printf("d:%3.0f%%",0);
    lcd.locate(0,2);
    lcd.printf("Teishachu!!");
    wait(5.0);
    pduty=vr2_adc.read();
    r_notch(pduty);
    wait(1.0);
    while(sens1==XOFF){
      pduty=vr2_adc.read();
      r_notch(pduty);
      lcd.locate(0,1);
      lcd.printf("d:%3.0f%%",pduty*100);
      lcd.locate(0,2);
      lcd.printf("r_notch ON!");

    }
    notch(0);
    wait(3.0);
  }//while
     
}//main
