// mRMCS04 Vr1,Vr2 control
// mbed RailModelContorolSystem

#include "mbed.h"
#include "TextLCD0420.h"

#define ON 1
#define OFF 0
#define XON 0
#define XOFF 1

DigitalOut mled1(LED1);
DigitalOut mled2(LED2);
DigitalOut mled3(LED3);
DigitalOut mled4(LED4);
AnalogIn vr1_adc(p15);
AnalogIn vr2_adc(p16);
DigitalIn sens1(p17);
DigitalIn sens2(p18);
DigitalIn sens3(p19);
PwmOut r1_pwm(p22);
PwmOut r2_pwm(p23);
DigitalOut po10(p5);
DigitalOut po11(p6);
DigitalOut po20(p7);
DigitalOut po21(p8);

TextLCD lcd(p24, p25, p26, p27, p28, p29, p30,20,4); // rs, rw, e, d0, d1, d2, d3

float pduty,pduty_slow;

void notch(float duty){
  r1_pwm.write(duty);
  r2_pwm.write(0);
}

void r_notch(float duty){
  r1_pwm.write(0);
  r2_pwm.write(duty);
}

int main() {      
  int i;
  float pduty;
  r1_pwm.pulsewidth(0.000001);//1us=0.000001
  r1_pwm.period(0.00001);//1ms=0.001s
  r2_pwm.pulsewidth(0.000001);//1us=0.000001
  r2_pwm.period(0.00001);//1ms=0.001s

  
  lcd.cls();
  lcd.locate(0,0);
  lcd.printf("** mbed RMCS04 **");
  
  
  while(1){
    for(i=0;i<20;i++){
      pduty=vr1_adc.read();
      notch(pduty);
      lcd.locate(0,1);
      lcd.printf("Vr1:notch on=> %2d",20-i);
      wait(1.0);
    }
    notch(0);
    wait(3.0);
    for(i=0;i<20;i++){
      pduty=vr2_adc.read();
      r_notch(pduty);
      lcd.locate(0,2);
      lcd.printf("Vr2:r_notch on=>%2d",20-i);
      wait(1.0);
    }
    r_notch(0);
    wait(3.0);
  }//while
     
}//main
