// TAGyro02
// Tamagawaseiki GYRO TAG201

#include "mbed.h"
#include "TextLCD0420.h"

#define ON 1
#define OFF 0
#define XON 0
#define XOFF 1

DigitalOut mled0(LED1);
DigitalOut mled1(LED2);
AnalogIn gy1_adc_in(p16);

TextLCD lcd(p24, p25, p26, p27, p28, p29, p30,20,4); // rs, rw, e, d0, d1, d2, d3

int main() {
  float gy1_data,gy1_adc,gy1_sum;
  int i;
  
  lcd.cls();
  lcd.locate(0,0);
  lcd.printf("*** TA-Gyro02 ***");
    
  while(1){        
    mled0=ON;
    gy1_sum=0;
    for(i=0;i<10;i++){
      mled1=ON;
      gy1_sum=gy1_sum+(gy1_adc_in.read()*5.0);
      wait(0.1);
    }
    mled0=OFF;
    gy1_data=gy1_sum/10;
    
    lcd.locate(0,1);
    lcd.printf("D:%3.2f",gy1_data);
    wait(1);
  }//while    
}//main      

