//Gyro test03-00
// Akidukidensi AE-GYRO-SMD
#include "mbed.h"
#include "TextLCD0420.h"

#define ON 1
#define OFF 0
#define Gy1_offset 0.01

DigitalOut mled0(LED1);
DigitalOut mled1(LED2);
AnalogIn gy1_adc(p16);
AnalogIn gy2_adc(p17);

TextLCD lcd(p24, p25, p26, p27, p28, p29, p30,20,4); // rs, rw, e, d0, d1, d2, d3

int main() {
  float gy1_data;
  float gy1_center;
  float gy1_sgm=0;
  float gy1_wk0=0,gy1_wk1=0;
  int i;
  
  lcd.cls();
  lcd.locate(0,0);
  lcd.printf("** Gyro test03-00 ***\n");

  gy1_center=gy1_adc.read()*3.3;  
  
  while(1){
    gy1_data=gy1_adc.read()*3.3;
    wait(0.1);
    
    gy1_wk1=(gy1_data-gy1_center)*1000/6.7;
    gy1_sgm=gy1_sgm+(gy1_wk0+gy1_wk1)*0.1/2;
    gy1_wk0=gy1_wk1;
    
    if(gy1_sgm > 90){
      gy1_sgm=90;  
    }
    if(gy1_sgm < -90){
      gy1_sgm=-90;
    }
    
    lcd.locate(0,1);
    lcd.printf("%3.4f %3.4f",gy1_center,gy1_data);
    lcd.locate(0,2);
    lcd.printf("Deg:%3.0f",gy1_sgm);
  }//while    
}//main      

