//GPS GT-720F Test06
#include "mbed.h"
#include "TextLCD0420.h"

#define ON 1
#define OFF 0

DigitalOut mled0(LED1);
DigitalOut mled1(LED2);

TextLCD lcd(p24, p25, p26, p27, p28, p29, p30,20,4); // rs, rw, e, d0, d1, d2, d3
Serial gps(p9,p10);

int main() {

      char c;
      int i,rlock,stn;
      char gps_data[256];
      char ns,ew;
      float time,hokui,tokei;
      float g_hokui,g_tokei;
      float d_hokui,m_hokui,d_tokei,m_tokei;
      int h_time,m_time,s_time;

      gps.baud(9600);
      lcd.cls();
      lcd.locate(0,0);
      lcd.printf("*** GPS GT-720F ***");    

    while (1) {
      i=0;
      while(gps.getc()!='$'){
      }
      
      while( (gps_data[i]=gps.getc()) != '\r'){
        i++;
        if(i==256){
           lcd.printf("*** Data read  Error! ***\n");
           i=255;
           break;
         }
      }
      gps_data[i]='\0';
      
      //test
      /* Test data
       rlock=1;
       stn=3;
       hokui=3532.25024; //=>35.537502
       tokei=13751.86820;//=>137.864471
       time=114107.046;
      */  
      if( sscanf(gps_data, "GPGGA,%f,%f,%c,%f,%c,%d,%d",&time,&hokui,&ns,&tokei,&ew,&rlock,&stn) >= 1){
        if(rlock >= 1){
         //hokui
          d_hokui=int(hokui/100);
          m_hokui=(hokui-d_hokui*100)/60;
          g_hokui=d_hokui+m_hokui;
         //tokei
          d_tokei=int(tokei/100);
          m_tokei=(tokei-d_tokei*100)/60;
          g_tokei=d_tokei+m_tokei;
          //g_hokui=int(hokui/100)+(hokui-int(hokui/100))/60;
          //g_tokei=int(tokei/100)+(tokei-int(tokei/100))/60;
          
         //time set
          h_time=int(time/10000);
          m_time=int((time-h_time*10000)/100);
          s_time=int(time-h_time*10000-m_time*100);
          h_time=h_time+9;//UTC =>JST 

          lcd.cls();
          lcd.locate(0,0);
          lcd.printf("*GPS JST %2d:%2d:%2d",h_time,m_time,s_time);  
          lcd.locate(0,1);
          lcd.printf("Lock(%d),Stn(%d)",rlock,stn);  
         //Latitude=Hokui
          lcd.locate(0,2);
          lcd.printf("Lat/d:%4.6f",g_hokui);
         // Logitude=tokei 
          lcd.locate(0,3);
          lcd.printf("Log/d:%4.6f",g_tokei);
        }
        else{
          lcd.locate(0,0);
          lcd.printf("*** GPS GT-720F ***");
          lcd.locate(0,1);
          lcd.printf("Lock(%d),Stn(%d)",rlock,stn);
          lcd.locate(0,2);
          for(i=0;i<40;i++){
            lcd.printf("%c",gps_data[i]);
          }
        }
      }//if
    }//while
}//main



