//GPS GT-720F Logger01
#include "mbed.h"
#include "TextLCD0420.h"

#define ON 1
#define OFF 0

DigitalOut mled0(LED1);
DigitalOut mled1(LED2);
DigitalIn sw1(p5);

TextLCD lcd(p24, p25, p26, p27, p28, p29, p30,20,4); // rs, rw, e, d0, d1, d2, d3
Serial gps(p9,p10);
LocalFileSystem local("local");
Ticker flipper;
FILE *fp;
float g_hokui,g_tokei;
int fp_count=0;

void gps_rec() {
  mled0=ON;
  fprintf(fp,"%4.6f,%3.6f,\n",g_tokei,g_hokui);
  wait(1.0);
  mled0=OFF;
  fp_count++;
}

int main() {

      char c;
      int i,rlock=0,stn=0;
      char gps_data[256];
      char ns,ew;
      float time,hokui,tokei;
 
      float d_hokui,m_hokui,d_tokei,m_tokei;
      int h_time=0,m_time=0,s_time=0;
      int rec_flag=0;
      
      gps.baud(9600);
      lcd.cls();
      lcd.printf("*** GPS GT-720F ****\n");    
      lcd.locate(0,1);
      lcd.printf("File open...\n");
      wait(1.0);
      fp=fopen("/local/GPS.txt","a");
      if(!fp || sw1==0){
        lcd.cls();
        lcd.printf("Can't Loging ... \n");
        lcd.printf("System close...\n");
        lcd.printf(">\n");
        exit(1);
      }
      lcd.printf("System start...\n");
      lcd.printf("Loging ready ok...\n");
      fprintf(fp,"\n");
      wait(1.0);
      
    while (1) {
      if(sw1==0){
        fclose(fp);
        lcd.cls();
        lcd.printf("System close...\n");
        lcd.printf(">\n");
        exit(1);    
      }
      
      i=0;
      while(gps.getc()!='$'){
      }
      
      while( (gps_data[i]=gps.getc()) != '\r'){
        i++;
        if(i==256){
           lcd.printf("*** Data read  Error! ***\n");
           i=255;
           break;
         }
      }
      gps_data[i]='\0';
      
      //test
      /* Test data
       rlock=1;
       stn=3;
       hokui=3532.25024; //=>35.537502
       tokei=13751.86820;//=>137.864471
       time=114107.046;
      */  
      if( sscanf(gps_data, "GPGGA,%f,%f,%c,%f,%c,%d,%d",&time,&hokui,&ns,&tokei,&ew,&rlock,&stn) >= 1){
        if(rlock >= 1){

         //hokui
          d_hokui=int(hokui/100);
          m_hokui=(hokui-d_hokui*100)/60;
          g_hokui=d_hokui+m_hokui;
         //tokei
          d_tokei=int(tokei/100);
          m_tokei=(tokei-d_tokei*100)/60;
          g_tokei=d_tokei+m_tokei;
         //g_hokui=int(hokui/100)+(hokui-int(hokui/100))/60;
         //g_tokei=int(tokei/100)+(tokei-int(tokei/100))/60;
          
         //time set
          h_time=int(time/10000);
          m_time=int((time-h_time*10000)/100);
          s_time=int(time-h_time*10000-m_time*100);
          h_time=h_time+9;//UTC =>JST
          
         // Record start
          if(rec_flag==0){
           flipper.attach(&gps_rec, 10.0);
           rec_flag=1;
           fprintf(fp,"JST %2d:%2d:%2d\n",h_time,m_time,s_time);
           lcd.cls();
           mled0=ON;
           lcd.printf("Loging start....");
           wait(5.0);
           mled0=ON;
          }  

          lcd.cls();
          lcd.locate(0,0);
          lcd.printf("*GPS JST %2d:%2d:%2d",h_time,m_time,s_time);  
          lcd.locate(0,1);
          lcd.printf("Lk(%d),St(%d),%d",rlock,stn,fp_count);  
         //Latitude=Hokui
          lcd.locate(0,2);
          lcd.printf("Lat/d:%4.6f",g_hokui);
         // Logitude=tokei 
          lcd.locate(0,3);
          lcd.printf("Log/d:%4.6f",g_tokei);
        }
        else{
          flipper.detach(); 
          rec_flag=0;
          lcd.cls();
          lcd.locate(0,0);
          lcd.printf("*** GPS GT-720F ***");
          lcd.locate(0,1);
          lcd.printf("Lk(%d),St(%d)",rlock,stn);
          lcd.locate(0,2);
          for(i=0;i<40;i++){
            lcd.printf("%c",gps_data[i]);
          }
        }
      }//if
    }//while
}//main



