#include "mbed.h"
#include "TextLCD0420.h"

#define ON 1
#define OFF 0

DigitalOut mled0(LED1);
DigitalOut mled1(LED2);

TextLCD lcd(p24, p25, p26, p27, p28, p29, p30,20,4); // rs, rw, e, d0, d1, d2, d3
Serial pc(USBTX, USBRX); // tx, rx 
Serial gps(p9,p10);

int main() {

      unsigned char c;
      int i,rlock;
      char gps_data[256],gps2_data[256];
      char ns,ew;
      float time,hokui,tokei;
      
      gps.baud(9600);
      lcd.cls();
      lcd.locate(0,0);
      lcd.printf("*** GPS GT-720F ***");    

    while (1) {
      i=0;
      while(gps.getc()!='$'){
      }
      
      while( (gps_data[i]=gps.getc()) != '\r'){
        i++;
        if(i==256){
           lcd.printf("*** Div Error! ***\n");
           i=255;
           break;
         }
      }
      gps_data[i]='\0';
      
      if( sscanf(gps_data, "GPGGA,%f,%f,%c,%f,%c,%d",&time,&hokui,&ns,&tokei,&ew,&rlock) >= 1){
        if(rlock==1){
          lcd.cls();
          lcd.locate(0,0);
          lcd.printf("*** GPS GT-720F ***"); 
          lcd.locate(0,1);
          lcd.printf("Status:Lock(%d)",rlock);  
         // logitude 
          lcd.locate(0,2);
          //lcd.printf"Log:%4.5f",tokei);
          lcd.printf("Tokiei:%4.5f",tokei);
         //Latitude
          lcd.locate(0,3);
          // lcd.printf("Lat:%4.5f",hokui);
          lcd.printf("Hokui:%4.5f",hokui);
          
        }
        else{
          lcd.locate(0,1);
          lcd.printf("Status:unLock(%d)",rlock);
          lcd.locate(0,2);
          for(i=0;i<40;i++){
            lcd.printf("%c",gps_data[i]);
          }
        }
      }//if
    }//while
}//main



