//2ak1009_Solar_VI
// for Solar charger Copyright by K.Takeuchi

#include "mbed.h"
#include "TextLCD2004.h"

#define ON 1
#define OFF 0
#define max_minutes 210
#define I_trim 0.15

AnalogIn Vbat_adc(p20);
AnalogIn Vsolar_adc(p19);
AnalogIn Isolar_adc(p18);

TextLCD lcd(p24, p25, p26, p27, p28, p29, p30,20,4); // rs, rw, e, d0, d1, d2, d3
LocalFileSystem local("local");

int main() {
      float Vbat,Vsolar,Isolar;
      float Isolar_sum,Isolar_avg,Vsolar_sum,Vsolar_avg,Wsolar;
      int k=0,s_count=60,m_count=max_minutes;
      lcd.cls();
      lcd.locate(0,0);
      lcd.printf("=Solar MPPT Sys.=");
      lcd.locate(0,1);
      lcd.printf("File open...");
      FILE *fp=fopen("/local/Solar.txt","a");
      if(!fp){
        lcd.locate(0,2);
        fprintf(stderr,"File/local/Solar.txt cant't opened");
        exit(1);
      }
      lcd.locate(0,1);
      lcd.printf("System start!!");
      fprintf(fp,"\n");
      wait(2.0);

      while(1){
        Vbat=Vbat_adc.read()*30;
        Vsolar=Vsolar_adc.read()*30;
        Isolar=(Isolar_adc.read()*3.3-2.5)/185*1000;
        Wsolar=Vsolar_avg*Isolar_avg;
        lcd.cls();
        lcd.locate(0,0);
        lcd.printf("=Solar MPPT Sys.=");
        lcd.locate(0,1);
        lcd.printf("Sp V:%2.1fV,I:%1.2fA",Vsolar_avg,Isolar_avg);
        lcd.locate(0,2);
        lcd.printf("Vbat:%2.1fV",Vbat);
        lcd.locate(0,3);
        lcd.printf("W:%2.1fW %d:%d",Wsolar,m_count,s_count);
        wait(0.5);
        lcd.locate(0,0);
        lcd.printf("=Solar MPPT Sys =");
        wait(0.5);
        Vsolar_sum=Vsolar_sum+Vsolar;
        Isolar_sum=Isolar_sum+Isolar;
        k++;
        if(k==10){
          k=0;
          Vsolar_avg=Vsolar_sum/10;
          Isolar_avg=Isolar_sum/10-I_trim;
          Vsolar_sum=0;
          Isolar_sum=0;
        }
        s_count--;
        if(s_count==0){
          s_count=60;
          m_count--;
          fprintf(fp,"%2d, %2.1f, %2.2f, %2.2f, %2.1f\n",m_count,Vsolar_avg,Isolar_avg,Wsolar,Vbat);
        }
        if(m_count ==0){
          lcd.cls();
          lcd.locate(0,0);
          lcd.printf("=Solar MPPT Sys.=");wait(0.2);
          lcd.locate(0,1);
          lcd.printf("File close...");wait(0.2);
          fprintf(fp,"\n");
          fclose(fp);
          lcd.locate(0,2);
          lcd.printf("Recording Finish!");
          wait(5.0);
          exit(1);
        }      
  }//while
}//main


