//2ak1009_Solar_VI
// for Solar charger Copyright by K.Takeuchi

#include "mbed.h"
#include "TextLCD2004.h"

#define ON 1
#define OFF 0

AnalogIn Vbat_adc(p20);
AnalogIn Vsolar_adc(p19);
AnalogIn Isolar_adc(p18);

TextLCD lcd(p24, p25, p26, p27, p28, p29, p30,20,4); // rs, rw, e, d0, d1, d2, d3
LocalFileSystem local("local");

int main() {
      float Vbat,Vsolar,Isolar;
      lcd.cls();
      lcd.locate(0,0);
      lcd.printf("=Solar MPPT Sys.=");
      lcd.locate(0,1);
      lcd.printf("System start!!");
      wait(2.0);
      
      while(1){
        Vbat=Vbat_adc.read()*30;
        Vsolar=Vsolar_adc.read()*30;
        Isolar=(Isolar_adc.read()*3.3-2.5)/185*1000;
        lcd.cls();
        lcd.locate(0,0);
        lcd.printf("=Solar MPPT Sys.=");
        lcd.locate(0,1);
        lcd.printf("Sp V:%2.1fV,I:%1.2fA",Vsolar,Isolar);
        lcd.locate(0,2);
        lcd.printf("Vbat:%2.1fV",Vbat);
        lcd.locate(0,3);
        lcd.printf("W:%2.2fW",Vsolar*Isolar);
        wait(0.5);
        lcd.locate(0,0);
        lcd.printf("=Solar MPPT Sys =");
        wait(0.5);
  }//while
}//main


