//2ak0927_Solar_LocalFile
// for Solar charger Copyright by K.Takeuchi

#include "mbed.h"
#include "TextLCD2004.h"

#define ON 1
#define OFF 0
#define max_minutes 120

AnalogIn Vbat_adc(p20);
AnalogIn Vsolar_adc(p19);

TextLCD lcd(p24, p25, p26, p27, p28, p29, p30,20,4); // rs, rw, e, d0, d1, d2, d3
LocalFileSystem local("local");

int main() {
      float Vbat,Vsolar,Vbat_tmp;
      int m_count,s_count;    
      m_count=0;
      s_count=0;
      lcd.cls();
      lcd.locate(0,0);
      lcd.printf("=Solar MPPT Sys.=");
      lcd.locate(0,1);
      lcd.printf("File open...");
      wait(2.0);
      FILE *fp=fopen("/local/Solar.txt","w");
      if(!fp){
        lcd.locate(0,2);
        fprintf(stderr,"File/local/Solar.txt cant't opened");
        exit(1);
      }
      lcd.locate(0,1);
      lcd.printf("System start!!");
      wait(2.0);

      while(1){
        Vbat=Vbat_adc.read()*30;
        Vbat=(Vbat+Vbat_tmp)/2;
        Vsolar=Vsolar_adc.read()*30;
        lcd.cls();
        lcd.locate(0,0);
        lcd.printf("=Solar MPPT Sys.=");
        lcd.locate(0,1);
        lcd.printf("Vsolar:%2.1fV %2dm%2ds",Vsolar,m_count,s_count);
        lcd.locate(0,2);
        lcd.printf("Vbat:%2.1fV",Vbat);
        if(Vsolar > Vbat){
          lcd.locate(0,3);
          lcd.printf("=== Charging ====");
        }
        else if(Vsolar < 2.0){
          lcd.locate(0,3);
          if(Vbat >= 12.6){
            lcd.printf("== Batt:100%% ==");
          }
          else if(Vbat >= 12.4){
            lcd.printf("== Batt:75%% ==");
          }
          else if(Vbat >= 12.2){
            lcd.printf("== Batt:50%% ==");
          }
          else if(Vbat >= 12.0){
            lcd.printf("== Batt:25%% ==");
          }
          else{
            lcd.printf("== Battery Low!! ==");
          }
        }
        Vbat_tmp=Vbat;
        wait(0.5);
        lcd.locate(0,0);
        lcd.printf("=Solar MPPT Sys =");
        wait(0.5);
        s_count++;
        if(s_count ==60){
          s_count=0;
          m_count++;
          fprintf(fp,"%2d, %2.1f, %2.1f\n",m_count,Vsolar,Vbat);
        }
        if(m_count==max_minutes){//Keisoku Time (minutes)
          fclose(fp);
          lcd.cls();
          lcd.locate(0,0);
          lcd.printf("=Solar MPPT Sys.=");wait(0.2);
          lcd.locate(0,1);
          lcd.printf("File close...");wait(0.2);
          wait(10.0);
          m_count++;
          //lcd.locate(0,2);
          //lcd.printf("Program exit!!");wait(0.2);
          //exit(1);
        }
  }//while
}//main


