//2ak0918_Solar_LCD20X04
// for Solar charger Copyright by K.Takeuchi

#include "mbed.h"
#include "TextLCD0420.h"

#define ON 1
#define OFF 0

DigitalOut mled0(LED1);
DigitalOut mled1(LED2);
AnalogIn Vbat_adc(p20);
AnalogIn Vsolar_adc(p19);

TextLCD lcd(p24, p25, p26, p27, p28, p29, p30,20,4); // rs, rw, e, d0, d1, d2, d3

int main() {
      float Vbat,Vsolar,Vbat_tmp;    
      lcd.cls();
      while(1){
        Vbat=Vbat_adc.read()*30;
        Vbat=(Vbat+Vbat_tmp)/2;
        Vsolar=Vsolar_adc.read()*30;
        lcd.cls();
        lcd.locate(0,0);
        lcd.printf("=Solar MPPT Sys.=");
        lcd.locate(0,1);
        lcd.printf("Vsolar:%2.1fV",Vsolar);
        lcd.locate(0,2);
        lcd.printf("Vbat:%2.1fV",Vbat);
        if(Vsolar > Vbat){
          lcd.locate(0,3);
          lcd.printf("=== Charging ====");
        }
        else if(Vsolar < 2.0){
          lcd.locate(0,3);
          if(Vbat >= 12.6){
            lcd.printf("== Batt:100%% ==");
          }
          else if(Vbat >= 12.4){
            lcd.printf("== Batt:75%% ==");
          }
          else if(Vbat >= 12.2){
            lcd.printf("== Batt:50%% ==");
          }
          else if(Vbat >= 12.0){
            lcd.printf("== Batt:25%% ==");
          }
          else{
            lcd.printf("== Battery Low!! ==");
          }
        }
        Vbat_tmp=Vbat;
        wait(0.5);
        lcd.locate(0,0);
        lcd.printf("=Solar MPPT Sys =");
        wait(0.5);
  }//while
}//main


