// PWM1
#include "mbed.h"
#include "TextLCD.h"

#define ON 1
#define OFF 0

DigitalOut mled1(LED1);
DigitalOut mled2(LED2);
DigitalOut mled3(LED3);
DigitalOut mled4(LED4);
AnalogIn vin_adc(p20);
AnalogIn vr_adc(p19);
PwmOut rout_pwm(p21);

TextLCD lcd(p24, p25, p26, p27, p28, p29, p30,16,2); // rs, rw, e, d0, d1, d2, d3
float adc_volt;

int main() {      
  float vr_data;
  rout_pwm.pulsewidth_us(10);
  rout_pwm.period_ms(1);
  rout_pwm.write(0.0);
  while(1){
      vr_data=vr_adc.read();
      lcd.cls();
      lcd.locate(0,0);
      lcd.printf("Vin:%2.1fV",vin_adc.read()*15);
      lcd.locate(0,1);
      lcd.printf("Dt:%2.0f%%",vr_data*100);
      rout_pwm.write(vr_data);
      mled1=ON;
      wait(vr_data);
      mled1=OFF;
      wait(vr_data);
  }//while    
}//main
