// IMU2 Ver2
//  hx "*" hyouji

#include "mbed.h"
#include "I2cLCD.h"

I2cLCD lcd(p28,p27,p26); //sda scl reset
Serial IMU(p9,p10);// p9=Tx,p10=Rx 

DigitalOut mled0(LED1);
DigitalOut mled1(LED2);
DigitalIn tsw(p11);

#define ON 1
#define OFF 0
#define XON 0
#define XOFF 1

double rx,px,hx;
double rx_imu,px_imu,hx_imu; 

void offset_can(){
   int i;
   lcd.cls();   
   IMU.printf("$TSC,OFC,10*CC\r\n");
   IMU.printf("$TSC,HRST*75\r\n");                 
   lcd.printf("now System init\n");
   for(i=0;i<5;i++){
      lcd.printf(".");
      wait(0.2);
   }
   lcd.cls();
}

void IMU_get(){
  int i;
  unsigned char c1,c2;  

  while(IMU.getc()!='$'){
  }
  for(i=1;i<=8;i++){
    c1=IMU.getc();
  }
  for(i=1;i<=20;i++){
    c1=IMU.getc();
  }
  c1=IMU.getc();
  c2=IMU.getc();
    rx_imu=float((c1 << 8) | c2);
  c1=IMU.getc();
  c2=IMU.getc();
    px_imu=float((c1 << 8) | c2);
  c1=IMU.getc();
  c2=IMU.getc();
    hx_imu=float((c1 << 8) | c2);
    
  rx=180*rx_imu/32768;
  px=180*px_imu/32768;
  hx=180*hx_imu/32768;
    
   // for hx
      if(hx >= 0 && hx <=90){
        hx=hx+90;
      }
      else if(hx >90 && hx <180){
        hx=180;
      }
      else if(hx >= 180 && hx <270){
        hx=0;
      }
      else if(hx >= 270 && hx <=360){
        hx=hx-270;
      }  
    
}


int main() {

   int hx_lc=7,hx_lc_old=7;
      IMU.baud(119200);
      lcd.cls();
      lcd.locate(0,0);
      lcd.printf("IMU2 Test03\n");
      lcd.printf("Init now...");
      IMU.printf("$TSC,HRST*75\r\n");
      wait(0.1);
      IMU.printf("$TSC,RAW,10\r\n");
      wait(0.1);
  
      lcd.cls();
      wait(0.1);
      mled0=OFF;
      
    while (1) {
      if(tsw==XON){
        mled0=ON;
        offset_can();
      }
      mled0=OFF;
      
      IMU_get();

      lcd.locate(0,0);
      lcd.printf("rx:%3.0f,px:%3.0f",rx,px);
      //lcd.locate(0,1);
      //lcd.printf("h:%5.1f",180*hx/32768);
      hx_lc=hx/11.25;
      if(hx_lc >=16){
        hx_lc=15;
      }
      //lcd.locate(0,1);
      //lcd.printf("%2d,%2d",hx_lc,hx_lc_old);
      
      lcd.locate(hx_lc_old,1);
      lcd.printf(" ");
      lcd.locate(hx_lc,1);
      lcd.printf("*");
      hx_lc_old=hx_lc;
 
    }//while
}//main