// LedMatrix  5mai fullset  final version

#include "mbed.h"
#include "BME280.h"
 
DigitalOut led(dp28);

BME280 sensor1(dp5,dp27,0x76 << 1);
BME280 sensor2(dp5,dp27,0x77 << 1);

// spi(mosi,miso,sck)
SPI max72_spi(dp2, NC, dp6);
DigitalOut load(dp14);//spi load

DigitalOut red(dp16);
DigitalOut yellow(dp17);
DigitalOut green(dp18);

// CPU       MT7219
// dp1 mosi(Master In Salve Out) =>   DIN
// dp2 miso(Master OutSlave)   =>   nc
// dp6 sck (Serial Clock) =>   clk
// dp14 =>(Slave Select) load

int maxInUse = 5;    //change this variable to set how many MAX7219's you'll use
 
// define max7219 registers
#define max7219_reg_noop         0x00
#define max7219_reg_digit0       0x01
#define max7219_reg_digit1       0x02
#define max7219_reg_digit2       0x03
#define max7219_reg_digit3       0x04
#define max7219_reg_digit4       0x05
#define max7219_reg_digit5       0x06
#define max7219_reg_digit6       0x07
#define max7219_reg_digit7       0x08
#define max7219_reg_decodeMode   0x09
#define max7219_reg_intensity    0x0a
#define max7219_reg_scanLimit    0x0b
#define max7219_reg_shutdown     0x0c
#define max7219_reg_displayTest  0x0f
 
#define LOW 0
#define HIGH 1
#define MHZ 1000000
#define ON 1
#define OFF 0

double p1,t1,h1,pp1;
double p2,t2,h2,pp2;
 
void maxSingle( int reg, int col) {
//maxSingle is the "easy"  function to use for a
//single max7219
    load = LOW;            // begin
    max72_spi.write(reg);  // specify register
    max72_spi.write(col);  // put data
    load = HIGH;           // make sure data is loaded (on rising edge of LOAD/CS)
}
 
void maxAll (int reg, int col) {    // initialize  all  MAX7219's in the system
    load = LOW;                    // begin
    for ( int c=1; c<= maxInUse; c++) {
        max72_spi.write(reg);  // specify register
        max72_spi.write(col);  // put data
    }
    load = HIGH;
}
 
void maxOne(int maxNr, int reg, int col) {
//maxOne is for adressing different MAX7219's,
//while having a couple of them cascaded
    int c = 0;
    load = LOW;
 
    for ( c = maxInUse; c >= maxNr; c--) {
        max72_spi.write(0);  // no-op
        max72_spi.write(0);  // no-op
    }
 
    max72_spi.write(reg);  // specify register
    max72_spi.write(col);  // put data
 
    for ( c=maxNr-1; c >= 1; c--) {
        max72_spi.write(0);  // no-op
        max72_spi.write(0);  // no-op
    }
    load = HIGH;
}
  
void setup () {
    // initiation of the max 7219
    // SPI setup: 8 bits, mode 0
    max72_spi.format(8, 0);
    
    // going by the datasheet, min clk is 100ns so theoretically 10MHz should work...
    // max72_spi.frequency(10*MHZ);
    
    maxAll(max7219_reg_scanLimit, 0x07);
    maxAll(max7219_reg_decodeMode, 0x00);  // using an led matrix (not digits)
    maxAll(max7219_reg_shutdown, 0x01);    // not in shutdown mode
    maxAll(max7219_reg_displayTest, 0x00); // no display test
    for (int e=1; e<=8; e++) {    // empty registers, turn all LEDs off
        maxAll(e,0);
    }
    maxAll(max7219_reg_intensity, 0x0f & 0x0f);    // the first 0x0f is the value you can set
    // range: 0x00 to 0x0f
} 
 
void get_sensor1(void){
    t1=sensor1.getTemperature();
    if(t1 > 85.0){
         t1=t1-409.0-1;
    }
    h1=sensor1.getHumidity();
    pp1=sensor1.getPressure(); 
    pp1=pp1+int(700/9);// kiatu kani hosei
} 

void get_sensor2(void){
    t2=sensor2.getTemperature();
    if(t2 > 85.0){
         t2=t2-409.0-1;
    }
    h2=sensor2.getHumidity();
    pp2=sensor2.getPressure(); 
    pp2=pp2+int(700/9);
}  
 
int main(void) {

 const uint64_t moji_font[] = {// bold font , kagami moji font
    /*0x3c66666e76663c00,//0~9
    0x7e1818181c181800,
    0x7e060c3060663c00,
    0x3c66603860663c00,
    0x30307e3234383000,
    0x3c6660603e067e00,
    0x3c66663e06663c00,
    0x1818183030667e00,
    0x3c66663c66663c00,
    0x3c66607c66663c00,*/
    
    0x1c2222222222221c,//0~9
    0x1c08080808080c08,
    0x3e0408102020221c,
    0x1c2220201820221c,
    0x20203e2224283020,
    0x1c2220201e02023e,
    0x1c2222221e02221c,
    0x040404081020203e,
    0x1c2222221c22221c,
    0x1c22203c2222221c,  
    0x6666663e06060600,// 10 h
    0x06063e66663e0000,// 11 p
    0x1818000000000000,// 12 .
    0x30480848340a0a04, // 13 dc
    0x1010157555770101,// 14 hp
    0x0010107c10100000,// 15 +
    0x0000007e00000000,// 16 -
    0x082a1c771c2a0800, //17 asuta1
    0x007e424a52427e00, // 18 sikaku2
    0x0000000000000000, // 19 blank
    0x60660c1830660600, // 20 %
    0x4242665a5a7e1800, // 21 uchi
    0x220424692e2a2c00,  // 22 soto
    0x126a3a22227a2200,// 23 ha
    0x44c6444c56640400,// 24 re
    0x2010080408102000,// 25 ku
    0x1028483e083e1000,// 26 mo
    0x1020404044444400,// 27 ri
    0x2874d27c107c1000,// 28 a
    0x449a9aaaaa7c2800,//  29 me
    0x6c927cc482443800,//  30 kumo
    0x30309254ba10aa28,//  31 ame
    0x082a1c771c2a0800,// 32 hare 
    0x1010101054381000,// 33 ue yajirusi
    0x0002044850607800,// 34 naname ue 
    0x0078605048040200,// 35 naname sita
    0x1038541010101000, // 36 sita
    0x0000183c3c180000, // 37 asuta2
    0x0010207e20100000,  // 38 onaji yajirusi
    0x5050557553550503  // 39 RH 
    };
    
/*
    
 const uint64_t moji_font[]={   
  0x006e333e301e0000,//a
  0x003b66663e060607,//b
  0x001e3303331e0000,//c
  0x006e33333e303038,//d
  0x001e033f331e0000,//e
  0x000f06060f06361c,//f
  0x1f303e33336e0000,//g
  0x006766666e360607,//h
  0x001e0c0c0c0e000c,//i
  0x1e33333030300030,//j
  0x0067361e36660607,//k
  0x001e0c0c0c0c0c0e,//l
  0x00636b7f7f330000,//m
  0x00333333331f0000,//n
  0x001e3333331e0000,//o
  0x0f063e66663b0000,//p
  0x78303e33336e0000,//q
  0x000f06666e3b0000,//r
  0x001f301e033e0000,//s
  0x00182c0c0c3e0c08,//t
  0x006e333333330000,//u
  0x000c1e3333330000,//v
  0x00367f7f6b630000,//w
  0x0063361c36630000,//x
  0x1f303e3333330000,//y
  0x003f260c193f0000 //z
 };

*/

//    // Jissainiha konoyouni mieru
//     maxSingle(1,1);                        |-| -------+
//     maxSingle(2,2);                        |-| ------+-
//     maxSingle(3,4);                        |-| -----+--
//     maxSingle(4,8);                        |-| ----+---
//     maxSingle(5,16);                       |-| ---+----
//     maxSingle(6,32);                       |-| --+-----
//     maxSingle(7,64);                       |-| -+------
//     maxSingle(8,128);                      |-| +-------
  
    int i,j,k,m,n;
    uint8_t bitsum[22][9],bit1gyou,bitline[350];
    uint64_t moji1,load_image[35];
    long hpascal,ttemp,sitemp;
    int hpketa[4],tpketa[3],siketa[3];
    int gdot[]={128,64,32,16,8,4,2,1};
    int gbit[40],gbit_s[80];
    long wtime=0;
    long hpdata[40],hprange,hpmax,hpmin;
    long hpcenter;
    int dotdata[40],fstloop,fshuuki;
    double hpscope;
    double gctrim=0.0;
    int henka=0;
    int yosou=1,yosou_old;
    int mojisu;
    double hpsum,hpavg;
 
    setup();
    
    wait(0.1);
    get_sensor1();
    get_sensor2();
    
    hpascal=long(pp1);
    hpmin=hpascal;
    hpmax=hpascal;
    hpscope=1;
    hprange=0;
    for(i=0;i<40;i++){
        hpdata[i]=hpascal-3;
    }
            
    while(1){
       
      get_sensor1();
      get_sensor2();
            
      hpascal=long(pp1);
      ttemp=long(t2*10); // seisuuchi henkan
      sitemp=long(h2);
 
      hpketa[0]=int(hpascal/1000);hpascal=hpascal-hpketa[0]*1000;
      hpketa[1]=int(hpascal/100); hpascal=hpascal-hpketa[1]*100;
      hpketa[2]=int(hpascal/10);  hpascal=hpascal-hpketa[2]*10;
      hpketa[3]=hpascal;
      
      tpketa[0]=int(ttemp/100);ttemp=ttemp-tpketa[0]*100;// jyuu noketa
      tpketa[1]=int(ttemp/10);ttemp=ttemp-tpketa[1]*10;// ichi no keta
      tpketa[2]=int(ttemp); // shousuutenika no keta
      
      siketa[0]=int(sitemp/100);sitemp=sitemp-siketa[0]*100;
      siketa[1]=int(sitemp/10);sitemp=sitemp-siketa[1]*10;
      siketa[2]=int(sitemp);
      
      load_image[0]=moji_font[19]; //blank        
      load_image[1]=moji_font[19]; //blank 

      if(hpdata[23] > hpdata[22]){
             load_image[2]=moji_font[34];//naname ue
      }
      else if(hpdata[23] < hpdata[22]){
             load_image[2]=moji_font[35];//naname sita
      }
      else{
             load_image[2]=moji_font[38];//onaji yajirusi
      }

      for(i=3;i<=6;i++){// kiatu 4keta suuji [3 ~ 6]
            for(j=0;j<=9;j++){
                if(hpketa[i-3] == j){
                    load_image[i]=moji_font[j];
                }
            }
      }
      load_image[7]=moji_font[14];//hp
      load_image[8]=moji_font[19]; //blank       
      
      if(t1 >=0){
          load_image[9]=moji_font[15];//+
      }
      else {
          load_image[9]=moji_font[16];// -
      }                

      for(i=0;i<=1;i++){// kion seisuuketa
          for(j=0;j<=9;j++){
              if(tpketa[i] == j){
                  load_image[i+10]=moji_font[j];
              }
          }
      }
      load_image[12]=moji_font[12];// .
      for(j=0;j<=9;j++){// kion shousuu keta
              if(tpketa[2] == j){
                  load_image[13]=moji_font[j];
              }
      }
      load_image[14]=moji_font[13]; //dc 

      load_image[15]=moji_font[19];//blank
      
       for(i=0;i<=2;i++){ // situdo 3 keta
            for(j=0;j<=9;j++){
                if(siketa[i] == j){
                    load_image[i+16]=moji_font[j];
                }
            }
       }
       if(siketa[0]==0){// 0 shouryaku
           load_image[16]=moji_font[39];// situdo
       }
       
             
       load_image[19]=moji_font[20]; // %

       load_image[20]=moji_font[19];//blank

      // Tenki yosoku
       henka=0;
       for(m=39;m>=32;m--){
           henka=henka+(hpdata[m]-hpdata[m-1]);
       }
       
       load_image[21]=load_image[2];// hadder
       
        if(henka >= 3){
            yosou=1;
            load_image[22]=moji_font[23];//ha
            load_image[23]=moji_font[24];//re
            load_image[24]=moji_font[38];//onaji yajirusi
            load_image[25]=moji_font[23];//ha
            load_image[26]=moji_font[24];//re
            load_image[27]=moji_font[34];//naname ue          
        }
        else if(henka ==1 || henka == 2){
            yosou=2;
            load_image[22]=moji_font[23];//ha
            load_image[23]=moji_font[24];//re
            load_image[24]=moji_font[38];//onaji yajirusi
            load_image[25]=moji_font[25];//ku
            load_image[26]=moji_font[26];//mo
            load_image[27]=moji_font[27];//ri          
        }    
        else if(henka == 0){
            yosou=3;
            if(yosou_old <= 3){
                load_image[22]=moji_font[25];//ku
                load_image[23]=moji_font[26];//mo
                load_image[24]=moji_font[27];//ri          
                load_image[25]=moji_font[34];//naname ue          
                load_image[26]=moji_font[23];//ha
                load_image[27]=moji_font[24];//re
            }
            else if(yosou_old >= 4){
                load_image[22]=moji_font[25];//ku
                load_image[23]=moji_font[26];//mo
                load_image[24]=moji_font[27];//ri          
                load_image[25]=moji_font[38];//onaji yajirusi
                load_image[26]=moji_font[28];//a
                load_image[27]=moji_font[29];//me
            }
                
         }
         else if(henka == -1 || henka ==-2){
            yosou=4;
            load_image[22]=moji_font[25];//ku
            load_image[23]=moji_font[26];//mo
            load_image[24]=moji_font[27];//ri          
            load_image[25]=moji_font[35];//naname sita
            load_image[26]=moji_font[28];//a
            load_image[27]=moji_font[29];//me

        }          
        else if(henka <= -3){
            yosou=5;
                load_image[22]=moji_font[28];//a
                load_image[23]=moji_font[29];//me
                load_image[24]=moji_font[38];//onaji yajirusi
                load_image[25]=moji_font[28];//a
                load_image[26]=moji_font[29];//me
                load_image[27]=moji_font[35];//naname sita
       }
       load_image[28]=moji_font[19];//blank
       load_image[29]=moji_font[19];//blank
       load_image[30]=moji_font[19];//blank
       
       mojisu=31;//0~30 31 moji
       
       for(i=0;i< mojisu;i++){ 
            moji1=load_image[i];
            for(j=0;j<8;j++){// bitsum[1]
                bitsum[i][j]=0;
            }//j
            for(j=0;j<8;j++){
                bit1gyou=moji1 & 0xff;
                for(k=0;k<8;k++){//  kagami moji no font
                //for(k=8;k>=1;k--){ // futuu no font
                    bitsum[i][k]=bitsum[i][k]+(bit1gyou & 0x01)*pow((double)2,(double)(j));
                    bit1gyou=bit1gyou >> 1;
                }//k
                moji1=moji1 >> 8;
            }//j
        }// i
        
        k=0;// bitline henkan
        for(i=0;i<mojisu;i++){
            for(j=0;j<8;j++){
                bitline[k]=bitsum[i][j];
                k++;
            }
        }
        
        for(i=0;i<=(mojisu*8-1-39);i++){// bitline hyouji
            k=i;
            maxOne(1,1,bitline[k]);
            maxOne(1,2,bitline[k+1]);
            maxOne(1,3,bitline[k+2]);
            maxOne(1,4,bitline[k+3]);
            maxOne(1,5,bitline[k+4]);
            maxOne(1,6,bitline[k+5]);
            maxOne(1,7,bitline[k+6]);
            maxOne(1,8,bitline[k+7]);
            maxOne(2,1,bitline[k+8]);
            maxOne(2,2,bitline[k+9]);
            maxOne(2,3,bitline[k+10]);
            maxOne(2,4,bitline[k+11]);
            maxOne(2,5,bitline[k+12]);
            maxOne(2,6,bitline[k+13]);
            maxOne(2,7,bitline[k+14]);
            maxOne(2,8,bitline[k+15]);
            maxOne(3,1,bitline[k+16]);
            maxOne(3,2,bitline[k+17]);
            maxOne(3,3,bitline[k+18]);
            maxOne(3,4,bitline[k+19]);
            maxOne(3,5,bitline[k+20]);
            maxOne(3,6,bitline[k+21]);
            maxOne(3,7,bitline[k+22]);
            maxOne(3,8,bitline[k+23]);
            maxOne(4,1,bitline[k+24]);
            maxOne(4,2,bitline[k+25]);
            maxOne(4,3,bitline[k+26]);
            maxOne(4,4,bitline[k+27]);
            maxOne(4,5,bitline[k+28]);
            maxOne(4,6,bitline[k+29]);
            maxOne(4,7,bitline[k+30]);
            maxOne(4,8,bitline[k+31]);
            maxOne(5,1,bitline[k+32]);
            maxOne(5,2,bitline[k+33]);
            maxOne(5,3,bitline[k+34]);
            maxOne(5,4,bitline[k+35]);
            maxOne(5,5,bitline[k+36]);
            maxOne(5,6,bitline[k+37]);
            maxOne(5,7,bitline[k+38]);
            maxOne(5,8,bitline[k+39]);
            wait(0.1);
        }                               
                
        hpascal=long(pp1);
        if(hpascal > hpdata[39]+5){
            hpascal=hpdata[39]+5;
        }
        if(hpascal < hpdata[39]-5){
            hpascal=hpdata[39]-5;
        }       
        hpdata[39]=hpascal;
        hpmax=hpdata[39];
        hpmin=hpdata[39];                          
        for(m=16;m<39;m++){ // graph bunseki 24h
            if(hpmax < hpdata[m]){
                hpmax=hpdata[m];
            }
            if(hpmin > hpdata[m]){
                hpmin=hpdata[m];
            }
        }//for
   
        hprange=hpmax-hpmin;// auto graph
        if(hprange <= -1){
            hprange=0;
        }
        if(hprange >= 8 ){//auto range hpscope set
            hpscope=double(hprange)/8.0;
        }
        else{
            hpscope=1.0;
        }
        if(hprange <= 3){//auto trim gctrim set
            gctrim=double(4-hprange);
        }
        else {
            gctrim=0;
        }
        for(m=1;m<=39;m++){
            dotdata[m]=int(double(hpdata[m]-hpmin)/hpscope)+gctrim;
            if(dotdata[m] < 0){
                dotdata[m]=0;
            }
            if(dotdata[m] > 7){
                dotdata[m]=7;
            }
            gbit[m]=gdot[dotdata[m]];
       }
       gbit[0]=gdot[int(hpscope+0.5-1)];//range hyouji        
                        
        for(i=0;i<40;i++){// graph scroll data
            gbit_s[i]=0;  // zenhan 0
        }
        for(i=40;i<80;i++){// kouhan jitu data
            gbit_s[i]=gbit[i-40];
        }
        
        for(k=0;k<40;k++){
            maxOne(1,1,gbit_s[k]);// graph scroll
            maxOne(1,2,gbit_s[k+1]);
            maxOne(1,3,gbit_s[k+2]);
            maxOne(1,4,gbit_s[k+3]);
            maxOne(1,5,gbit_s[k+4]);
            maxOne(1,6,gbit_s[k+5]);
            maxOne(1,7,gbit_s[k+6]);
            maxOne(1,8,gbit_s[k+7]);
            maxOne(2,1,gbit_s[k+8]);
            maxOne(2,2,gbit_s[k+9]);
            maxOne(2,3,gbit_s[k+10]);
            maxOne(2,4,gbit_s[k+11]);
            maxOne(2,5,gbit_s[k+12]);
            maxOne(2,6,gbit_s[k+13]);
            maxOne(2,7,gbit_s[k+14]);
            maxOne(2,8,gbit_s[k+15]);
            maxOne(3,1,gbit_s[k+16]);
            maxOne(3,2,gbit_s[k+17]);
            maxOne(3,3,gbit_s[k+18]);
            maxOne(3,4,gbit_s[k+19]);
            maxOne(3,5,gbit_s[k+20]);
            maxOne(3,6,gbit_s[k+21]);
            maxOne(3,7,gbit_s[k+22]);
            maxOne(3,8,gbit_s[k+23]);
            maxOne(4,1,gbit_s[k+24]);
            maxOne(4,2,gbit_s[k+25]);
            maxOne(4,3,gbit_s[k+26]);
            maxOne(4,4,gbit_s[k+27]);
            maxOne(4,5,gbit_s[k+28]);
            maxOne(4,6,gbit_s[k+29]);
            maxOne(4,7,gbit_s[k+30]);
            maxOne(4,8,gbit_s[k+31]);
            maxOne(5,1,gbit_s[k+32]);
            maxOne(5,2,gbit_s[k+33]);
            maxOne(5,3,gbit_s[k+34]);
            maxOne(5,4,gbit_s[k+35]);
            maxOne(5,5,gbit_s[k+36]);
            maxOne(5,6,gbit_s[k+37]);
            maxOne(5,7,gbit_s[k+38]);
            maxOne(5,8,gbit_s[k+39]);
            wait(0.1);
        } 
               
        k=0;
        maxOne(1,1,gbit[k]);// kiatu graph hyouji
        maxOne(1,2,gbit[k+1]);
        maxOne(1,3,gbit[k+2]);
        maxOne(1,4,gbit[k+3]);
        maxOne(1,5,gbit[k+4]);
        maxOne(1,6,gbit[k+5]);
        maxOne(1,7,gbit[k+6]);
        maxOne(1,8,gbit[k+7]);
        maxOne(2,1,gbit[k+8]);
        maxOne(2,2,gbit[k+9]);
        maxOne(2,3,gbit[k+10]);
        maxOne(2,4,gbit[k+11]);
        maxOne(2,5,gbit[k+12]);
        maxOne(2,6,gbit[k+13]);
        maxOne(2,7,gbit[k+14]);
        maxOne(2,8,gbit[k+15]);
        maxOne(3,1,gbit[k+16]);
        maxOne(3,2,gbit[k+17]);
        maxOne(3,3,gbit[k+18]);
        maxOne(3,4,gbit[k+19]);
        maxOne(3,5,gbit[k+20]);
        maxOne(3,6,gbit[k+21]);
        maxOne(3,7,gbit[k+22]);
        maxOne(3,8,gbit[k+23]);
        maxOne(4,1,gbit[k+24]);
        maxOne(4,2,gbit[k+25]);
        maxOne(4,3,gbit[k+26]);
        maxOne(4,4,gbit[k+27]);
        maxOne(4,5,gbit[k+28]);
        maxOne(4,6,gbit[k+29]);
        maxOne(4,7,gbit[k+30]);
        maxOne(4,8,gbit[k+31]);
        maxOne(5,1,gbit[k+32]);
        maxOne(5,2,gbit[k+33]);
        maxOne(5,3,gbit[k+34]);
        maxOne(5,4,gbit[k+35]);
        maxOne(5,5,gbit[k+36]);
        maxOne(5,6,gbit[k+37]);
        maxOne(5,7,gbit[k+38]);
        maxOne(5,8,gbit[k+39]);

       for(i=0;i<4;i++){
           wait(0.5);
           maxOne(5,8,0);
           maxOne(1,1,0);
           wait(0.5);
           maxOne(1,1,gbit[k]);
           maxOne(5,8,gbit[k+39]);
       }
       
       fshuuki=120;// kousin jikan
       wtime++;
       if(wtime == fshuuki){
           yosou_old=yosou;
           for(m=1;m<=38;m++){
               hpdata[m]=hpdata[m+1];
           }
           wtime=0;
       }      
                    
    }//while
}//main


