// LedMatrix  2mai 

#include "mbed.h"
 
DigitalOut led(dp28);

// spi(mosi,miso,sck)
SPI max72_spi(dp2, NC, dp6);
DigitalOut load(dp14);//spi load

// CPU       MT7219
// dp1 mosi(Master In Salve Out) =>   DIN
// dp2 miso(Master OutSlave)   =>   nc
// dp6 sck (Serial Clock) =>   clk
// dp14 =>(Slave Select) load
 
int maxInUse = 2;    //change this variable to set how many MAX7219's you'll use
 
// define max7219 registers
#define max7219_reg_noop         0x00
#define max7219_reg_digit0       0x01
#define max7219_reg_digit1       0x02
#define max7219_reg_digit2       0x03
#define max7219_reg_digit3       0x04
#define max7219_reg_digit4       0x05
#define max7219_reg_digit5       0x06
#define max7219_reg_digit6       0x07
#define max7219_reg_digit7       0x08
#define max7219_reg_decodeMode   0x09
#define max7219_reg_intensity    0x0a
#define max7219_reg_scanLimit    0x0b
#define max7219_reg_shutdown     0x0c
#define max7219_reg_displayTest  0x0f
 
#define LOW 0
#define HIGH 1
#define MHZ 1000000
#define ON 1
#define OFF 0

void maxSingle( int reg, int col) {
//maxSingle is the "easy"  function to use for a
//single max7219
    load = LOW;            // begin
    max72_spi.write(reg);  // specify register
    max72_spi.write(col);  // put data
    load = HIGH;           // make sure data is loaded (on rising edge of LOAD/CS)
}
 
void maxAll (int reg, int col) {    // initialize  all  MAX7219's in the system
    load = LOW;                    // begin
    for ( int c=1; c<= maxInUse; c++) {
        max72_spi.write(reg);  // specify register
        max72_spi.write(col);  // put data
    }
    load = HIGH;
}
 
void maxOne(int maxNr, int reg, int col) {
//maxOne is for adressing different MAX7219's,
//while having a couple of them cascaded
    int c = 0;
    load = LOW;
 
    for ( c = maxInUse; c >= maxNr; c--) {
        max72_spi.write(0);  // no-op
        max72_spi.write(0);  // no-op
    }
 
    max72_spi.write(reg);  // specify register
    max72_spi.write(col);  // put data
 
    for ( c=maxNr-1; c >= 1; c--) {
        max72_spi.write(0);  // no-op
        max72_spi.write(0);  // no-op
    }
    load = HIGH;
}
  
void setup () {
    // initiation of the max 7219
    // SPI setup: 8 bits, mode 0
    max72_spi.format(8, 0);
    
    // going by the datasheet, min clk is 100ns so theoretically 10MHz should work...
    // max72_spi.frequency(10*MHZ);
    
    maxAll(max7219_reg_scanLimit, 0x07);
    maxAll(max7219_reg_decodeMode, 0x00);  // using an led matrix (not digits)
    maxAll(max7219_reg_shutdown, 0x01);    // not in shutdown mode
    maxAll(max7219_reg_displayTest, 0x00); // no display test
    for (int e=1; e<=8; e++) {    // empty registers, turn all LEDs off
        maxAll(e,0);
    }
    maxAll(max7219_reg_intensity, 0x0f & 0x0f);    // the first 0x0f is the value you can set
    // range: 0x00 to 0x0f
} 
 
void led_flash(){
    int i;
    for(i=0;i<3;i++){
        led=ON;
        wait(0.1);
        led=OFF;
        wait(0.1);
    }
}

int main(void) {

    const uint64_t moji_font[] = {// bold font , kagami moji font
        0x3c66666e76663c00,//0~9
        0x7e1818181c181800,
        0x7e060c3060663c00,
        0x3c66603860663c00,
        0x30307e3234383000,
        0x3c6660603e067e00,
        0x3c66663e06663c00,
        0x1818183030667e00,
        0x3c66663c66663c00,
        0x3c66607c66663c00,
    };
    
    int i,j,k;
    uint8_t bitsum[1][8],bit1gyou,bitline[80];
    uint64_t moji1;
    
    setup();
    led_flash();
    wait(0.1);
    
    while(1){
       
        for(i=0;i<10;i++){
            moji1=moji_font[i];// 0~9 
            for(j=0;j<8;j++){
                bitsum[i][j]=0;
            }
            for(j=0;j<8;j++){
                bit1gyou=moji1 & 0xff;
                for(k=0;k<8;k++){// kagamimoji no font
                //for(k=8;k>=1;k--){ // futuu no font
                    bitsum[i][k]=bitsum[i][k]+(bit1gyou & 0x01)*pow((double)2,(double)(j));
                    bit1gyou=bit1gyou >> 1;
                 }//i
                 moji1=moji1 >> 8; 
            }//j
        }
        
        k=0;
        for(i=0;i<10;i++){// scroll data henkan
            for(j=0;j<8;j++){
                bitline[k]=bitsum[i][j];
                k++;
            }
        }
        
        for(i=0;i<80-16;i++){ //scroll hyouji      
            maxOne(1,1,bitline[i+0]);
            maxOne(1,2,bitline[i+1]);
            maxOne(1,3,bitline[i+2]);
            maxOne(1,4,bitline[i+3]);
            maxOne(1,5,bitline[i+4]);
            maxOne(1,6,bitline[i+5]);
            maxOne(1,7,bitline[i+6]);
            maxOne(1,8,bitline[i+7]);
            maxOne(2,1,bitline[i+8]);
            maxOne(2,2,bitline[i+9]);
            maxOne(2,3,bitline[i+10]);
            maxOne(2,4,bitline[i+11]);
            maxOne(2,5,bitline[i+12]);
            maxOne(2,6,bitline[i+13]);
            maxOne(2,7,bitline[i+14]);
            maxOne(2,8,bitline[i+15]);
 
            wait(0.1);
        }
                       
    }//while
}//main


