// LedMatrix  1mai 

#include "mbed.h"
 
DigitalOut led(dp28);

// spi(mosi,miso,sck)
SPI max72_spi(dp2, NC, dp6);
DigitalOut load(dp14);//spi load

// CPU       MT7219
// dp1 mosi(Master In Salve Out) =>   DIN
// dp2 miso(Master OutSlave)   =>   nc
// dp6 sck (Serial Clock) =>   clk
// dp14 =>(Slave Select) load

 
int maxInUse = 1;    //change this variable to set how many MAX7219's you'll use
 
// define max7219 registers
#define max7219_reg_noop         0x00
#define max7219_reg_digit0       0x01
#define max7219_reg_digit1       0x02
#define max7219_reg_digit2       0x03
#define max7219_reg_digit3       0x04
#define max7219_reg_digit4       0x05
#define max7219_reg_digit5       0x06
#define max7219_reg_digit6       0x07
#define max7219_reg_digit7       0x08
#define max7219_reg_decodeMode   0x09
#define max7219_reg_intensity    0x0a
#define max7219_reg_scanLimit    0x0b
#define max7219_reg_shutdown     0x0c
#define max7219_reg_displayTest  0x0f
 
#define LOW 0
#define HIGH 1
#define MHZ 1000000
#define ON 1
#define OFF 0

void maxSingle( int reg, int col) {
//maxSingle is the "easy"  function to use for a
//single max7219
    load = LOW;            // begin
    max72_spi.write(reg);  // specify register
    max72_spi.write(col);  // put data
    load = HIGH;           // make sure data is loaded (on rising edge of LOAD/CS)
}
 
void maxAll (int reg, int col) {    // initialize  all  MAX7219's in the system
    load = LOW;                    // begin
    for ( int c=1; c<= maxInUse; c++) {
        max72_spi.write(reg);  // specify register
        max72_spi.write(col);  // put data
    }
    load = HIGH;
}
 
void maxOne(int maxNr, int reg, int col) {
//maxOne is for adressing different MAX7219's,
//while having a couple of them cascaded
    int c = 0;
    load = LOW;
 
    for ( c = maxInUse; c >= maxNr; c--) {
        max72_spi.write(0);  // no-op
        max72_spi.write(0);  // no-op
    }
 
    max72_spi.write(reg);  // specify register
    max72_spi.write(col);  // put data
 
    for ( c=maxNr-1; c >= 1; c--) {
        max72_spi.write(0);  // no-op
        max72_spi.write(0);  // no-op
    }
    load = HIGH;
}
  
void setup () {
    // initiation of the max 7219
    // SPI setup: 8 bits, mode 0
    max72_spi.format(8, 0);
    
    // going by the datasheet, min clk is 100ns so theoretically 10MHz should work...
    // max72_spi.frequency(10*MHZ);
    
    maxAll(max7219_reg_scanLimit, 0x07);
    maxAll(max7219_reg_decodeMode, 0x00);  // using an led matrix (not digits)
    maxAll(max7219_reg_shutdown, 0x01);    // not in shutdown mode
    maxAll(max7219_reg_displayTest, 0x00); // no display test
    for (int e=1; e<=8; e++) {    // empty registers, turn all LEDs off
        maxAll(e,0);
    }
    maxAll(max7219_reg_intensity, 0x0f & 0x0f);    // the first 0x0f is the value you can set
    // range: 0x00 to 0x0f
} 

void led_flash(){
    int i;
    for(i=0;i<3;i++){
        led=ON;
        wait(0.1);
        led=OFF;
        wait(0.1);
    }
}
 
 
int main(void) {

    led_flash();
    setup();

    while(1){
        
        led=ON;
        maxSingle(1,1);       //                 |-| -------+
        maxSingle(2,2);       //                 |-| ------+-
        maxSingle(3,4);       //                 |-| -----+--
        maxSingle(4,8);       //                 |-| ----+---
        maxSingle(5,16);      //                 |-| ---+----
        maxSingle(6,32);      //                 |-| --+-----
        maxSingle(7,64);      //                 |-| -+------
        maxSingle(8,128);     //                 |-| +-------
        wait(0.1);
 
        led=OFF;
        maxSingle(1,0);                       
        maxSingle(2,0);       
        maxSingle(3,0);       
        maxSingle(4,0);       
        maxSingle(5,0);      
        maxSingle(6,0);      
        maxSingle(7,0);      
        maxSingle(8,0);     
        wait(0.1);
        
    }//while
}//main


