 // VI Meter Kiban


#include "mbed.h"
#include "I2cLCD.h"

I2cLCD lcd(dp5,dp27,dp26); //sda scl reset
I2C Ina226(dp5,dp27);//SDA SCL
DigitalOut led_yellow(dp16);
DigitalOut led_green(dp15);

unsigned int waddr=0x80,raddr=0x81;
char cmd[3],val[3];
double vc,ic,ihosei;

#define ON 1
#define OFF 0
#define XON 0
#define XOFF 1

#define batt1_ON lcd.seticon( I2cLCD::Battery_1 )
#define batt2_ON lcd.seticon( I2cLCD::Battery_2 )
#define batt3_ON lcd.seticon( I2cLCD::Battery_3 ) 
#define batt4_ON lcd.seticon( I2cLCD::Battery_4 )

#define batt1_OFF lcd.clearicon( I2cLCD::Battery_1 )
#define batt2_OFF lcd.clearicon( I2cLCD::Battery_2 )
#define batt3_OFF lcd.clearicon( I2cLCD::Battery_3 ) 
#define batt4_OFF lcd.clearicon( I2cLCD::Battery_4 )

#define arrow_down_on lcd.seticon( I2cLCD::ArrowDown );
#define arrow_up_on   lcd.seticon( I2cLCD::ArrowUp );
#define arrow_down_off lcd.clearicon( I2cLCD::ArrowDown ); 
#define arrow_up_off   lcd.clearicon( I2cLCD::ArrowUp );

/*
void batt_mark(){
    if(vc < 4.5 ){
      batt1_ON;
      batt2_OFF;
      batt3_OFF;
      batt4_OFF;
    }
    else if(vc < 4.8){
      batt1_ON;
      batt2_ON;
      batt3_OFF;
      batt4_OFF;
    }
    else if(vc < 5.0){
      batt1_ON;
      batt2_ON;
      batt3_ON;
      batt4_OFF;
    }
    else{
      batt1_ON;
      batt2_ON;
      batt3_ON;
      batt4_ON;
    }
}     
*/
      
void led_flash(){
    int i;
    for(i=0;i<3;i++){
      led_green=ON;
      led_yellow=ON;
      wait(0.1);
      led_green=OFF;
      led_yellow=OFF;
      wait(0.1);
    }
}

int main() {      

  led_flash();
  lcd.cls();
  lcd.locate(0,0);
  lcd.printf("* VI Meter 1.1 *");
  
  cmd[0]=0x05;// calibration registar
  cmd[1]=0x0a;// shunt reg=2m ohm
  cmd[2]=0x00;
  Ina226.write(waddr,cmd,3);
  wait(0.1);
  
  cmd[0]=0x00;// config reg.
  cmd[1]=0x45;// average set & number=16
  cmd[2]=0x27;
  Ina226.write(waddr,cmd,3);
  wait(0.1);
  
  cmd[0]=0x04;// current read
  Ina226.write(waddr,cmd,1);
  Ina226.read(raddr,val,2);
  ic=(short)(val[0]<<8 | val[1]);
  if(-3.0 <ic && ic < 3.0 ){
    ihosei=0.0-ic;
  }    
  wait(0.1);
    
  while(1){
  
    cmd[0]=0x04;// current read
    Ina226.write(waddr,cmd,1);
    Ina226.read(raddr,val,2);
    ic=(short)(val[0]<<8 | val[1])+ihosei;
    if(ic < 0){ //discharge
      arrow_down_on;
      arrow_up_off;
      led_green=OFF;
      led_yellow=ON;
    }
    else{ //charge
      arrow_up_on;
      arrow_down_off;
      led_green=ON;
      led_yellow=OFF; 
    }
      
    wait(0.1);
 
    cmd[0]=0x02;// voltage read
    Ina226.write(waddr,cmd,1);
    Ina226.read(raddr,val,2);
    vc=(val[0]<<8 | val[1])*1.25/1000;
 /*   
    cmd[0]=0x03;// power
    Ina226.write(waddr,cmd,1);
    Ina226.read(raddr,val,2);
    pw=(val[0]<<8 | val[1])/25;
 
    
    pw=out_v*ic/1000;// power 
    if(out_v >= 12.0){
      out_v=12.0;
    }
    if(pduty <= 0.03){
      out_v=0;
    }
*/ 
 
    lcd.locate(0,1);
    lcd.printf("%4.1fV,%4.0fmA",vc,ic);        

    led_green=ON;
    wait(1.0);
    led_green=OFF;
    wait(1.0);
    
   // batt_mark();
 
  }//while     
}//main

