#include <stdio.h>
#include "mbed.h"
#include "Serial.h"
#include "ICM20689.h"

#define BUF_SIZE    (3000)


//#########################################################
// Global objects
//#########################################################
DigitalOut      led_g(LED1);
DigitalOut      led_b(LED2);
DigitalOut      led_r(LED3);
Serial          sp(PD_5, PD_6, 115200);//TX,RX
Serial          pc(USBTX, USBRX,115200); // tx, rx
ICM20689        imu[1];
Timer           t;

float           bufTime[BUF_SIZE];
int16_t         bufGyroX[BUF_SIZE];
int16_t         bufGyroY[BUF_SIZE];
int16_t         bufGyroZ[BUF_SIZE];
int16_t         bufAccelX[BUF_SIZE];
int16_t         bufAccelY[BUF_SIZE];
int16_t         bufAccelZ[BUF_SIZE];
//#########################################################
//
//#########################################################

//------------------------------------------------------
//初期化
//------------------------------------------------------
void init(){     
    char id;   
    pc.printf("********************\r\n");
    pc.printf(" START\r\n");
    pc.printf(" int=%d[byte]\r\n"       ,sizeof(int));
    pc.printf(" int16_t=%d[byte]\r\n"   ,sizeof(int16_t));
    pc.printf(" short=%d[byte]\r\n"     ,sizeof(short));
    pc.printf(" float=%d[byte]\r\n"     ,sizeof(float));
    pc.printf("********************\r\n");
    
    imu[0].Init(4);
    imu[0].Config();
    
    id = imu[0].Who_are_you();
    pc.printf("ID=0x%02X\r\n"     ,id);
    
    if(0x98 != id){
        led_r = 1; // red signal 
        while(1){;;}
    }
    led_g =1;
}
//------------------------------------------------------
// IMUからgetしたdataをソフトウェアbufferにpushする
//------------------------------------------------------
void Loging(const float rate,const int num){
    float    time_now    =0;
    float    time_diff   =0;
    float    time_last   =0;
    
    pc.printf("Loging start!\n");
    //Timer refresh
    t.stop();
    t.reset();
    t.start();
    int n=0;
    led_b =1;//brinl blue LED
    
    do{
        //wait for sample rate.
        do{
            time_now = t.read();
            time_diff = time_now - time_last;
        }while (time_diff < rate);
        time_last = time_now;
        
        //IMU data sumpling
        imu[0].Update();
        imu[0].getGyro(&bufGyroX[n] ,&bufGyroY[n] ,&bufGyroZ[n] );
        imu[0].getAccel(&bufAccelX[n] ,&bufAccelY[n] ,&bufAccelZ[n] );
        bufTime[n] = time_now;
        n++;
    }while(n < num);
    t.stop();
    pc.printf("Loging End!\n");
    led_b =0;
}
//------------------------------------------------------
//　ソフトウェアbufferの中身をfrintする
//------------------------------------------------------
void getLog(){
    led_r =1;
    for(int i=0; i<BUF_SIZE; i++){
        pc.printf("%d\t%f\t",i,bufTime[i]);
        pc.printf("%d\t%d\t%d\t",bufGyroX[i] ,bufGyroY[i] ,bufGyroZ[i]);
        pc.printf("%d\t%d\t%d\n",bufAccelX[i] ,bufAccelY[i] ,bufAccelZ[i]);

        sp.printf("%d\t%f\t%d\t%d\t%d\n",i,bufTime[i], bufGyroX[i] ,bufGyroY[i] ,bufGyroZ[i]);
    }
    led_r =0;
}
//------------------------------------------------------
// get temperature date
//------------------------------------------------------
void getTemp(){
    int16_t temp;
    imu[0].Update();
    imu[0].getTemp(&temp);
    pc.printf("temp\t%d\n",temp);
}
//------------------------------------------------------
// main loop. ターミナルの文字を監視
//------------------------------------------------------
int main(){
    init();
    while(true) {
        if( pc.readable() ) {
            char ch = pc.getc();
            //pc.putc(ch); //echo back
            //command parse
            switch(ch){
                case 'f': Loging(0.001,BUF_SIZE)  ; break;//fast sampling
                case 'l': Loging(0.01,BUF_SIZE)   ; break;//long sampling
                case 'g': getLog()                ; break;
                case 't': getTemp()               ; break;
                default :                         ; break;
            }
        }//if
    }// loop
}
