#pragma once
#include "SPI.h"
#include "DigitalOut.h"
using namespace mbed;

//---------------------------------------
//
//---------------------------------------
class ICM20689{
public:
    void        Init(int num);
    char        Who_are_you(void);
    int         Config(void);
    int         Update(void);
    uint16_t    getGyro(int16_t* x, int16_t* y, int16_t* z);
    uint16_t    getGyro(float* x, float* y, float* z);
    uint16_t    getTemp(int16_t* temp);
    uint16_t    getAccel(int16_t* x, int16_t* y, int16_t* z);
    uint16_t    getAccel(float* x, float* y, float* z);
private:
    //------types------
    typedef union {
        uint8_t     BYTE[14];
        struct {        
            struct {
                int16_t   X ;//[1:0]
                int16_t   Y ;//[3:2]
                int16_t   Z ;//[5:4]
            }ACCEL;
            int16_t     TEMP;//[7:6]
            struct {
                int16_t   X ;//[9:8]
                int16_t   Y ;//[11:10]
                int16_t   Z ;//[13:12]
            }GYRO;
        }VAL;
    }uBUF_IMU;
    //------values------
    SPI*        _spi;
    DigitalOut* _spi_cs;
    uBUF_IMU    _buf;
    float       _LsbGyro;
    float       _LsbAccel;
    float       _LsbTemp;
    float       _OffsetTemp;
    //------functions------
    int         icmSpiReadRegister(uint8_t reg, uint8_t length, uint8_t *data); 
    void        icmSpiWriteRegister(uint8_t adr, uint8_t data);
};

