#include "ICM20689.h"
#include "mbed.h"

void ICM20689::Init(int num){
    switch(num){
        case 1:
            _spi     = new SPI(PB_5 , PB_4 , PB_3); //mosi,miso,clk,cs
            _spi_cs  = new DigitalOut(PA_4);
            break;
        case 2:
            _spi     = new SPI(PC_3 , PC_2 , PD_3); //mosi,miso,clk,cs
            _spi_cs  = new DigitalOut(PB_12);
            break;
        case 3:
            _spi     = new SPI(PC_12 , PC_11, PC_10); //mosi,miso,clk,cs
            _spi_cs  = new DigitalOut(PD_2);
            break;
        case 4:
            _spi     = new SPI(PE_6 , PE_5 , PE_2); //mosi,miso,clk,cs
            _spi_cs  = new DigitalOut(PE_4);
            break;
        default:
            _spi     = new SPI(PF_9 , PF_8 , PF_7); //mosi,miso,clk,cs
            _spi_cs  = new DigitalOut(PG_1);
            break;
    }
    _spi->format(8,3);        //3:Riseedge,nomal Low   
    _spi->frequency(500000);  //500kHz
}

char ICM20689::Who_are_you(){
    uint8_t    rtn;
    icmSpiReadRegister(0x75,1,&rtn);
    return rtn;
}

int ICM20689::Config(void){
    //Device Reset
    icmSpiWriteRegister(0x6B, 0x80); osDelay(100);//デバイスリセット
    icmSpiWriteRegister(0x68, 0x03); osDelay(100);//シグナルパスのリセット
    icmSpiWriteRegister(0x6B, 0x03); osDelay(100);//クロック選択
    icmSpiWriteRegister(0x6A, 0x0D); osDelay(100);//riset
    icmSpiWriteRegister(0x6A, 0x50); osDelay(100);//I2C無効化
    icmSpiWriteRegister(0x6C, 0x00); osDelay(100);//スタンバイ解除
    icmSpiWriteRegister(0x19, 0x00); osDelay(100);//サンプリングレート
    icmSpiWriteRegister(0x1B, 0x08); osDelay(100);//ジャイロ設定
    icmSpiWriteRegister(0x1A, 0x01); osDelay(100);//コンフィグ設定
    icmSpiWriteRegister(0x1C, 0x10); osDelay(100);//加速度センサ設定
    icmSpiWriteRegister(0x1D, 0x02); osDelay(100);//加速度センサ設定
    icmSpiWriteRegister(0x37, 0x04); osDelay(100);//割込み設定
    icmSpiWriteRegister(0x38, 0x01); osDelay(100);//割込み有効    
    icmSpiWriteRegister(0x23, 0x00); osDelay(100);//FIFO無効    
//    icmSpiWriteRegister(0x68, 0x03); osDelay(100);//シグナルパスのリセット
    
    _LsbGyro    = 2.66462e-4;
    _LsbAccel   = 2.394202e-3;
    _LsbTemp    = 3.059976e-3;
    _OffsetTemp = 25.0;
  return 0;
}

int ICM20689::Update(void){
    *_spi_cs = 0;
    _spi->write(0x3B | 0x80);        // read access => bit[7]=1
    _buf.BYTE[1] = _spi->write(0x00);//Accel
    _buf.BYTE[0] = _spi->write(0x00);
    _buf.BYTE[3] = _spi->write(0x00);
    _buf.BYTE[2] = _spi->write(0x00);
    _buf.BYTE[5] = _spi->write(0x00);
    _buf.BYTE[4] = _spi->write(0x00);

    _buf.BYTE[7] = _spi->write(0x00);//Temp
    _buf.BYTE[6] = _spi->write(0x00);

    _buf.BYTE[9] = _spi->write(0x00);//Gyro
    _buf.BYTE[8] = _spi->write(0x00);
    _buf.BYTE[11]= _spi->write(0x00);
    _buf.BYTE[10]= _spi->write(0x00);
    _buf.BYTE[13]= _spi->write(0x00);
    _buf.BYTE[12]= _spi->write(0x00);    
    *_spi_cs = 1;
    return 0;
}

uint16_t ICM20689::getGyro(int16_t* x, int16_t* y, int16_t* z){
    *x = _buf.VAL.GYRO.X;
    *y = _buf.VAL.GYRO.Y;
    *z = _buf.VAL.GYRO.Z;
    return 0;
}
uint16_t ICM20689::getGyro(float* x, float* y, float* z){
    *x = (float)_buf.VAL.GYRO.X * _LsbGyro;
    *y = (float)_buf.VAL.GYRO.Y * _LsbGyro;
    *z = (float)_buf.VAL.GYRO.Z * _LsbGyro;
    return 0;
}
uint16_t ICM20689::getTemp(int16_t* temp){
    *temp = _buf.VAL.TEMP;
    return 0;
}

uint16_t ICM20689::getAccel(int16_t* x, int16_t* y, int16_t* z){
    *x = _buf.VAL.ACCEL.X;
    *y = _buf.VAL.ACCEL.Y;
    *z = _buf.VAL.ACCEL.Z;
    return 0;
}
uint16_t ICM20689::getAccel(float* x, float* y, float* z){
    *x = (float)_buf.VAL.ACCEL.X * _LsbAccel;
    *y = (float)_buf.VAL.ACCEL.Y * _LsbAccel;
    *z = (float)_buf.VAL.ACCEL.Z * _LsbAccel;
    return 0;
}
//---------------------------------------------------------------------------
// Local function
//---------------------------------------------------------------------------
int ICM20689::icmSpiReadRegister(uint8_t reg, uint8_t length, uint8_t *data){
    reg |= 0x80;// read access => bit[7]=1
    *_spi_cs = 0;
    _spi->write(reg);
    for(int i=0; i<length; i++){
        data[i] = _spi->write(0x00);
    }
    *_spi_cs = 1;
    return 0;   
}

void ICM20689::icmSpiWriteRegister(uint8_t adr, uint8_t data){
    *_spi_cs = 0;
    _spi->write(0x7F & adr);
    _spi->write( data     );
    *_spi_cs = 1;
}
