#include "mbed.h"
#include "DSHOT150.h"
#include <stdio.h>

DSHOT150    motor( p21 );
AnalogIn    ain(p20);
DigitalOut  led1(LED1);
DigitalOut  led2(LED2);
DigitalOut  led3(LED3);
DigitalOut  led4(LED4);
InterruptIn mot_pls(p5);
Timer       tim;

bool    is_running = false;
bool    print_exe  = false;
float   t;

void flip() {
    led1 = !led1;
    if(is_running == false){
        tim.start();
        is_running = true;
    }else{
        t = tim.read();
        tim.reset();
        print_exe = true;
        led2 = !led2;
    }   
}

int main() { 
    float val = 0;
    led2 = 0;
    led3 = 1;
    led4 = 1;
//    pc.set_baud(115200);
    motor.arm();
    motor.get_tel( false );
    mot_pls.rise(&flip);
    while (1){
        val = ain;
        motor.throttle( val );
        if(print_exe == true){
            print_exe = false;
            printf("%f\n", t);
        }
    }    
}