#include "BMI088.h"
#include "mbed.h"

float ax = 0, ay = 0, az = 0;
float gx = 0, gy = 0, gz = 0;
int16_t temp = 0;

DigitalOut led1(LED1);
DigitalOut led2(LED2);

Serial pc(USBTX, USBRX);

BMI088 bmi088;

int main()
{
    led1 = 0;
    pc.baud(9600);
    pc.printf("BMI088 Raw Data\n\r");
    
    while (1) 
    {
        if (bmi088.isConnection()) {
            bmi088.initialize();
            pc.printf("BMI088 is connected\n\r");
            break;
        } else {
            pc.printf("BMI088 is not connected\n\r");
        }
        led1 = !led1;
        wait_ms(200);
    }
    while(1)
    {
        led1 = 0;
        led2 = !led2;
        bmi088.getAcceleration(&ax, &ay, &az);
        bmi088.getGyroscope(&gx, &gy, &gz);
        temp = bmi088.getTemperature();
        
        pc.printf("acc: %2.4f %2.4f %2.4f\n\r", ax, ay, az);
        pc.printf("gyr: %2.4f %2.4f %2.4f\n\r", gx, gy, gz);
    
        pc.printf("temp: %d\n\r", temp);
        wait_ms(500);   
    }
}